/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.Axis;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoButtonEvent;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.sensors.SoAlarmSensor;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;
import com.openinventor.inventor.viewercomponents.nodes.SceneOrbiter;

class InteractionOrbiter {
    private static final float SELECTION_EPSILON = 0.05f;
    private SoCameraInteractor m_cameraInteractor;
    private boolean m_selectionAllowed;
    private boolean m_isButton1Down;
    private SbVec2f m_mouseNormPosition;
    private SbVec2s m_mousePosition;
    private int m_mouseWheelDelta;
    private long m_eventTime;
    protected SceneOrbiter.RotationMethods m_orbitMethod;
    protected Axis m_upAxis;
    protected float m_turntableConstraintLevel;
    private int m_interactiveCount;
    private SoHandleEventAction m_currentAction;
    private SoAlarmSensor m_interactionEndSensor;
    private static final double INTERACTION_TIME = 0.5;
    private static final double MAX_INTERACTION_SPEED = 3.0;

    public InteractionOrbiter(SoCameraInteractor soCameraInteractor) {
        this.m_cameraInteractor = soCameraInteractor;
        this.m_selectionAllowed = false;
        this.m_isButton1Down = false;
        this.m_mouseNormPosition = new SbVec2f();
        this.m_mousePosition = new SbVec2s();
        this.m_mouseWheelDelta = SoPreferences.getInteger((String)"OIV_WHEEL_DELTA", (int)120);
        this.m_eventTime = 0L;
        this.m_orbitMethod = SceneOrbiter.RotationMethods.TURNTABLE;
        this.m_upAxis = Axis.Y;
        this.m_turntableConstraintLevel = 0.0f;
        this.m_interactiveCount = 0;
        this.m_currentAction = null;
        this.m_interactionEndSensor = new SoAlarmSensor((Runnable)new InteractionEndSensorTask());
    }

    public void setCameraInteractor(SoCameraInteractor soCameraInteractor) {
        this.m_cameraInteractor = soCameraInteractor;
    }

    public void beginAction(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        SoMouseButtonEvent.Buttons buttons = soMouseButtonEvent.getButton();
        SoButtonEvent.States states = soMouseButtonEvent.getState();
        if (buttons == SoMouseButtonEvent.Buttons.BUTTON1) {
            this.m_isButton1Down = states == SoButtonEvent.States.DOWN;
            boolean bl = soMouseButtonEvent.wasCtrlDown();
            boolean bl2 = soMouseButtonEvent.wasShiftDown();
            if (!this.m_isButton1Down && this.m_selectionAllowed && !bl && !bl2) {
                return;
            }
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            this.m_mouseNormPosition = soMouseButtonEvent.getNormalizedPosition(sbViewportRegion);
            this.beginAction(soHandleEventAction, soMouseButtonEvent.wasCtrlDown(), soMouseButtonEvent.wasShiftDown());
            if (!this.m_isButton1Down && !this.m_selectionAllowed) {
                soHandleEventAction.setHandled();
            }
        }
    }

    public void beginAction(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        SoKeyboardEvent.Keys keys = soKeyboardEvent.getKey();
        SoButtonEvent.States states = soKeyboardEvent.getState();
        if (keys == SoKeyboardEvent.Keys.LEFT_CONTROL || keys == SoKeyboardEvent.Keys.LEFT_SHIFT) {
            this.m_selectionAllowed = false;
        }
        switch (keys) {
            case LEFT_CONTROL: {
                this.beginAction(soHandleEventAction, states == SoButtonEvent.States.DOWN, soKeyboardEvent.wasShiftDown());
                break;
            }
            case LEFT_SHIFT: {
                this.beginAction(soHandleEventAction, soKeyboardEvent.wasCtrlDown(), states == SoButtonEvent.States.DOWN);
                break;
            }
        }
    }

    protected void beginAction(SoHandleEventAction soHandleEventAction, boolean bl, boolean bl2) {
        this.m_currentAction = soHandleEventAction;
        if (this.m_isButton1Down && bl) {
            this.beginPan(soHandleEventAction);
        } else if (this.m_isButton1Down && !bl2) {
            this.beginSelection(soHandleEventAction);
        }
    }

    public void doAction(SoMouseWheelEvent soMouseWheelEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        int n = soMouseWheelEvent.getDelta() / this.m_mouseWheelDelta;
        float f = (float)Math.pow(2.0, (double)n * Math.PI / 180.0);
        this.doDollyWithCenter(this.m_mouseNormPosition, f, soHandleEventAction);
    }

    public void doAction(SoLocation2Event soLocation2Event, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        boolean bl = soLocation2Event.wasCtrlDown();
        boolean bl2 = soLocation2Event.wasShiftDown();
        if (this.m_isButton1Down && bl) {
            this.doPan((SoEvent)soLocation2Event, soHandleEventAction);
        } else if (this.m_isButton1Down && bl2) {
            this.doDolly((SoEvent)soLocation2Event, soHandleEventAction);
        } else if (this.m_isButton1Down) {
            if (this.m_selectionAllowed) {
                this.doIdentifyGesture((SoEvent)soLocation2Event, soHandleEventAction);
            } else {
                this.doOrbit((SoEvent)soLocation2Event, soHandleEventAction);
            }
        }
        if (!soHandleEventAction.isHandled()) {
            this.m_mouseNormPosition = soLocation2Event.getNormalizedPosition(soHandleEventAction.getViewportRegion());
        }
    }

    protected void beginPan(SoHandleEventAction soHandleEventAction) {
        this.m_cameraInteractor.activatePanning(this.m_mouseNormPosition, soHandleEventAction.getViewportRegion());
        soHandleEventAction.setHandled();
    }

    protected void beginSelection(SoHandleEventAction soHandleEventAction) {
        this.m_selectionAllowed = true;
    }

    protected void beginOrbit(SoHandleEventAction soHandleEventAction) {
        switch (this.m_orbitMethod) {
            case TRACKBALL: {
                this.m_cameraInteractor.activateOrbiting(this.m_mouseNormPosition);
                this.m_cameraInteractor.setRotationCenter(this.m_cameraInteractor.getFocalPoint());
                break;
            }
            case TURNTABLE: {
                this.m_mousePosition = soHandleEventAction.getEvent().getPosition();
                this.m_eventTime = soHandleEventAction.getEvent().getTime().getMsecValue();
                break;
            }
        }
        soHandleEventAction.setHandled();
    }

    protected void doIdentifyGesture(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        SbVec2f sbVec2f = soEvent.getNormalizedPosition(sbViewportRegion);
        SbVec2f sbVec2f2 = sbVec2f.minus(this.m_mouseNormPosition);
        float f = sbVec2f2.length();
        if (f > 0.05f) {
            this.m_selectionAllowed = false;
            this.m_mouseNormPosition = soEvent.getNormalizedPosition(sbViewportRegion);
            this.beginOrbit(soHandleEventAction);
        }
        soHandleEventAction.setHandled();
    }

    protected void doDolly(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        this.startInteraction();
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        SbVec2f sbVec2f = soEvent.getNormalizedPosition(sbViewportRegion);
        float f = (float)Math.pow(2.0, 10.0f * (sbVec2f.getY() - this.m_mouseNormPosition.getY()));
        this.m_cameraInteractor.dolly(f);
        this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
        this.m_mouseNormPosition = sbVec2f;
        soHandleEventAction.setHandled();
    }

    protected void doDollyWithCenter(SbVec2f sbVec2f, float f, SoHandleEventAction soHandleEventAction) {
        this.startInteraction();
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        this.m_cameraInteractor.dollyWithZoomCenter(sbVec2f, f, sbViewportRegion);
        this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
        soHandleEventAction.setHandled();
    }

    protected void doOrbit(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        this.startInteraction();
        switch (this.m_orbitMethod) {
            case TURNTABLE: {
                this.doTurntableOrbit(soEvent, soHandleEventAction);
                break;
            }
            default: {
                SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
                this.m_mouseNormPosition = soEvent.getNormalizedPosition(sbViewportRegion);
                this.m_cameraInteractor.orbit(this.m_mouseNormPosition);
            }
        }
        soHandleEventAction.setHandled();
    }

    private void doTurntableOrbit(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        SbVec3f sbVec3f;
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        double d = Math.PI * 2 / (double)Math.min(sbViewportRegion.getViewportSizePixels().getX(), sbViewportRegion.getViewportSizePixels().getY()) * 0.8;
        SbVec2s sbVec2s = soEvent.getPosition();
        long l = soEvent.getTime().getMsecValue();
        int n = this.m_mousePosition.getX() - sbVec2s.getX();
        int n2 = sbVec2s.getY() - this.m_mousePosition.getY();
        double d2 = (double)n * d;
        double d3 = (double)n2 * d;
        float f = l - this.m_eventTime;
        double d4 = Math.sqrt(n * n + n2 * n2);
        double d5 = f == 0.0f ? 0.0 : d4 / (double)f;
        double d6 = d5 > 3.0 ? 0.0 : 1.0 - d5 / 3.0;
        boolean bl = d6 < (double)this.m_turntableConstraintLevel;
        SbMatrix sbMatrix = this.m_cameraInteractor.getCamera().orientation.getValue().getMatrix();
        SbVec3f sbVec3f2 = this.m_cameraInteractor.getFocalPoint();
        n = Math.abs(n);
        n2 = Math.abs(n2);
        if (!bl || n >= n2) {
            switch (this.m_upAxis) {
                case X: {
                    sbVec3f = new SbVec3f(sbMatrix.getElement(0, 0), sbMatrix.getElement(0, 1), sbMatrix.getElement(0, 2));
                    break;
                }
                case Z: {
                    sbVec3f = new SbVec3f(sbMatrix.getElement(2, 0), sbMatrix.getElement(2, 1), sbMatrix.getElement(2, 2));
                    break;
                }
                default: {
                    sbVec3f = new SbVec3f(sbMatrix.getElement(1, 0), sbMatrix.getElement(1, 1), sbMatrix.getElement(1, 2));
                }
            }
            this.m_cameraInteractor.setRotationAxis(sbVec3f);
            this.m_cameraInteractor.setRotationCenter(sbVec3f2);
            this.m_cameraInteractor.rotate((float)d2);
        }
        if (!bl || n2 >= n) {
            sbVec3f = new SbVec3f(1.0f, 0.0f, 0.0f);
            this.m_cameraInteractor.setRotationAxis(sbVec3f);
            this.m_cameraInteractor.setRotationCenter(sbVec3f2);
            this.m_cameraInteractor.rotate((float)d3);
        }
        this.m_mousePosition = sbVec2s;
        this.m_eventTime = l;
    }

    protected void doPan(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        this.startInteraction();
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        this.m_mouseNormPosition = soEvent.getNormalizedPosition(sbViewportRegion);
        this.m_cameraInteractor.pan(this.m_mouseNormPosition, sbViewportRegion);
        soHandleEventAction.setHandled();
    }

    protected void interactiveCountInc() {
        ++this.m_interactiveCount;
        if (this.m_interactiveCount == 1 && this.m_currentAction != null) {
            this.m_currentAction.getSceneManager().setInteractive(true);
            this.m_currentAction.getSceneManager().scheduleRedraw();
        }
    }

    protected void interactiveCountDec() {
        if (this.m_interactiveCount > 0) {
            --this.m_interactiveCount;
            if (this.m_interactiveCount == 0 && this.m_currentAction != null) {
                this.m_currentAction.getSceneManager().setInteractive(false);
                this.m_currentAction.getSceneManager().scheduleRedraw();
            }
        }
    }

    private void startInteraction() {
        if (this.m_interactionEndSensor.isScheduled()) {
            this.m_interactionEndSensor.unschedule();
        } else {
            this.interactiveCountInc();
        }
        this.m_interactionEndSensor.setTimeFromNow(new SbTime(0.5));
        this.m_interactionEndSensor.schedule();
    }

    private class InteractionEndSensorTask
    implements Runnable {
        private InteractionEndSensorTask() {
        }

        @Override
        public void run() {
            InteractionOrbiter.this.interactiveCountDec();
        }
    }
}

