/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.actions.SoRayPickAction;
import com.openinventor.inventor.events.SoButtonEvent;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.gestures.events.SoDoubleTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoLongTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoRotateGestureEvent;
import com.openinventor.inventor.gestures.events.SoScaleGestureEvent;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoAlarmSensor;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import com.openinventor.inventor.viewercomponents.SoCameraInteractor;
import com.openinventor.inventor.viewercomponents.nodes.AnimatorListener;
import com.openinventor.inventor.viewercomponents.nodes.BaseInteraction;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SeekAnimator;
import java.util.ArrayList;

abstract class NavigationInteraction
extends BaseInteraction {
    private SoCameraInteractor m_cameraInteractor;
    public boolean m_isZoomEnabled;
    public boolean m_isPanEnabled;
    public boolean m_isOrbitEnabled;
    public boolean m_isRotateEnabled;
    private final boolean m_isAutoClippingPlanes;
    public ArrayList<SceneExaminer.InteractionModeListener> m_modeListeners;
    public boolean m_isSeekEnabled;
    private boolean m_isSeekMode;
    private SeekAnimator m_seekAnimator;
    protected boolean m_isButton1Down;
    protected boolean m_isButton2Down;
    protected SbVec2f m_mouseNormPosition;
    protected int m_mouseWheelDelta;
    private int m_interactiveCount;
    private SoHandleEventAction m_currentAction;
    private SoAlarmSensor m_interactionEndSensor;
    private static final double INTERACTION_TIME = 0.5;

    public NavigationInteraction(SoCameraInteractor soCameraInteractor) {
        this.m_cameraInteractor = soCameraInteractor;
        this.m_isZoomEnabled = true;
        this.m_isPanEnabled = true;
        this.m_isOrbitEnabled = true;
        this.m_isRotateEnabled = true;
        this.m_isAutoClippingPlanes = SoPreferences.getBoolean((String)"OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", (boolean)true);
        this.m_modeListeners = new ArrayList();
        this.m_isSeekEnabled = true;
        this.m_isSeekMode = false;
        this.m_seekAnimator = new SeekAnimator(soCameraInteractor, null);
        this.m_seekAnimator.setListener(new SeekAnimatorListener());
        this.m_isButton1Down = false;
        this.m_isButton2Down = false;
        this.m_mouseNormPosition = new SbVec2f();
        this.m_mouseWheelDelta = SoPreferences.getInteger((String)"OIV_WHEEL_DELTA", (int)120);
        this.m_interactiveCount = 0;
        this.m_currentAction = null;
        this.m_interactionEndSensor = new SoAlarmSensor((Runnable)new InteractionEndSensorTask());
    }

    public NavigationInteraction(NavigationInteraction navigationInteraction) {
        this.m_cameraInteractor = navigationInteraction.m_cameraInteractor;
        this.m_isZoomEnabled = navigationInteraction.m_isZoomEnabled;
        this.m_isPanEnabled = navigationInteraction.m_isPanEnabled;
        this.m_isOrbitEnabled = navigationInteraction.m_isOrbitEnabled;
        this.m_isRotateEnabled = navigationInteraction.m_isRotateEnabled;
        this.m_isAutoClippingPlanes = navigationInteraction.m_isAutoClippingPlanes;
        this.m_modeListeners = navigationInteraction.m_modeListeners;
        this.m_isSeekEnabled = navigationInteraction.m_isSeekEnabled;
        this.m_isSeekMode = navigationInteraction.m_isSeekMode;
        this.m_seekAnimator = navigationInteraction.m_seekAnimator;
        this.m_seekAnimator.setListener(new SeekAnimatorListener());
        this.m_isButton1Down = navigationInteraction.m_isButton1Down;
        this.m_isButton2Down = navigationInteraction.m_isButton2Down;
        this.m_mouseNormPosition = new SbVec2f(navigationInteraction.m_mouseNormPosition);
        this.m_mouseWheelDelta = navigationInteraction.m_mouseWheelDelta;
        this.m_interactiveCount = navigationInteraction.m_interactiveCount;
        this.m_currentAction = null;
        this.m_interactionEndSensor = new SoAlarmSensor((Runnable)new InteractionEndSensorTask());
    }

    public void reset() {
        this.m_isButton1Down = false;
        this.m_isButton2Down = false;
        this.setSeekMode(false);
        if (this.m_interactiveCount > 0) {
            this.m_interactiveCount = 1;
            this.interactiveCountDec();
        }
        this.m_currentAction = null;
    }

    public void setCameraInteractor(SoCameraInteractor soCameraInteractor) {
        this.m_cameraInteractor = soCameraInteractor;
        this.m_seekAnimator.setCameraInteractor(soCameraInteractor);
    }

    public void setSeekMode(boolean bl) {
        if (!bl) {
            this.m_seekAnimator.stop();
        }
        this.m_isSeekMode = bl;
        for (SceneExaminer.InteractionModeListener interactionModeListener : this.m_modeListeners) {
            interactionModeListener.seekModeChanged(bl);
        }
    }

    private void doSeek(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        SoNode soNode = soHandleEventAction.getNodeAppliedTo();
        SoRayPickAction soRayPickAction = new SoRayPickAction(sbViewportRegion);
        soRayPickAction.setSceneManager(soHandleEventAction.getSceneManager());
        soRayPickAction.setNormalizedPoint(soEvent.getNormalizedPosition(sbViewportRegion));
        soRayPickAction.setRadius(1.0f);
        soRayPickAction.setPickAll(false);
        soRayPickAction.apply(soNode);
        SoPickedPoint soPickedPoint = soRayPickAction.getPickedPoint();
        if (soPickedPoint == null) {
            this.setSeekMode(false);
        } else {
            this.m_seekAnimator.setSceneGraph(soNode);
            this.m_seekAnimator.setUp(soPickedPoint.getPoint(), sbViewportRegion);
            this.m_seekAnimator.start();
        }
        soHandleEventAction.setHandled();
    }

    @Override
    public void beginAction(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        SoMouseButtonEvent.Buttons buttons = soMouseButtonEvent.getButton();
        SoButtonEvent.States states = soMouseButtonEvent.getState();
        if (buttons == SoMouseButtonEvent.Buttons.BUTTON1) {
            this.m_isButton1Down = states == SoButtonEvent.States.DOWN;
        } else if (buttons == SoMouseButtonEvent.Buttons.BUTTON2) {
            this.m_isButton2Down = states == SoButtonEvent.States.DOWN;
        }
        this.m_currentAction = soHandleEventAction;
        if (this.m_isButton1Down && this.m_isSeekMode) {
            this.doSeek((SoEvent)soMouseButtonEvent, soHandleEventAction);
        } else {
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            this.m_mouseNormPosition = soMouseButtonEvent.getNormalizedPosition(sbViewportRegion);
            this.beginAction(soHandleEventAction, soMouseButtonEvent.wasCtrlDown(), soMouseButtonEvent.wasShiftDown());
        }
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    @Override
    public void beginAction(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        SoKeyboardEvent.Keys keys = soKeyboardEvent.getKey();
        SoButtonEvent.States states = soKeyboardEvent.getState();
        this.m_currentAction = soHandleEventAction;
        switch (keys) {
            case S: {
                if (!this.m_isSeekEnabled || states != SoButtonEvent.States.DOWN) break;
                this.setSeekMode(!this.m_isSeekMode);
                soHandleEventAction.setHandled();
                break;
            }
            case LEFT_CONTROL: {
                this.beginAction(soHandleEventAction, states == SoButtonEvent.States.DOWN, soKeyboardEvent.wasShiftDown());
                break;
            }
            case LEFT_SHIFT: {
                this.beginAction(soHandleEventAction, soKeyboardEvent.wasCtrlDown(), states == SoButtonEvent.States.DOWN);
                break;
            }
        }
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    protected abstract void beginAction(SoHandleEventAction var1, boolean var2, boolean var3);

    @Override
    public void doAction(SoMouseWheelEvent soMouseWheelEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        int n = soMouseWheelEvent.getDelta() / this.m_mouseWheelDelta;
        float f = (float)Math.pow(2.0, (double)n * Math.PI / 180.0);
        this.doDollyWithCenter(this.m_mouseNormPosition, f, soHandleEventAction);
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    @Override
    public void doAction(SoScaleGestureEvent soScaleGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        float f = soScaleGestureEvent.getDeltaScaleFactor();
        SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
        SbVec2f sbVec2f = sbViewportRegion.normalize(soScaleGestureEvent.getPosition());
        this.doDollyWithCenter(sbVec2f, 1.0f / f, soHandleEventAction);
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    @Override
    public void doAction(SoRotateGestureEvent soRotateGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        this.doRotate(soRotateGestureEvent, soHandleEventAction);
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    @Override
    public void doAction(SoDoubleTapGestureEvent soDoubleTapGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        if (this.m_isSeekEnabled) {
            this.setSeekMode(true);
            this.doSeek((SoEvent)soDoubleTapGestureEvent, soHandleEventAction);
        }
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    @Override
    public void doAction(SoLongTapGestureEvent soLongTapGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentAction = soHandleEventAction;
        if (!this.propageEvents()) {
            soHandleEventAction.setHandled();
        }
    }

    protected void beginPan(SoHandleEventAction soHandleEventAction) {
        if (this.m_isPanEnabled) {
            this.m_cameraInteractor.activatePanning(this.m_mouseNormPosition, soHandleEventAction.getViewportRegion());
            soHandleEventAction.setHandled();
        }
    }

    protected void beginOrbit(SoHandleEventAction soHandleEventAction) {
        if (this.m_isOrbitEnabled) {
            this.m_cameraInteractor.activateOrbiting(this.m_mouseNormPosition);
            this.m_cameraInteractor.setRotationCenter(this.m_cameraInteractor.getFocalPoint());
            soHandleEventAction.setHandled();
        }
    }

    protected void doDolly(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isZoomEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            SbVec2f sbVec2f = soEvent.getNormalizedPosition(sbViewportRegion);
            float f = (float)Math.pow(2.0, 10.0f * (sbVec2f.getY() - this.m_mouseNormPosition.getY()));
            this.m_cameraInteractor.dolly(f);
            if (this.m_isAutoClippingPlanes) {
                this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
            }
            this.m_mouseNormPosition = sbVec2f;
            soHandleEventAction.setHandled();
        }
    }

    protected void doDollyWithCenter(SbVec2f sbVec2f, float f, SoHandleEventAction soHandleEventAction) {
        if (this.m_isZoomEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            this.m_cameraInteractor.dollyWithZoomCenter(sbVec2f, f, sbViewportRegion);
            if (this.m_isAutoClippingPlanes) {
                this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
            }
            soHandleEventAction.setHandled();
        }
    }

    protected void doOrbit(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isOrbitEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            this.m_mouseNormPosition = soEvent.getNormalizedPosition(sbViewportRegion);
            this.m_cameraInteractor.orbit(this.m_mouseNormPosition);
            if (this.m_isAutoClippingPlanes) {
                this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
            }
            soHandleEventAction.setHandled();
        }
    }

    protected void doPan(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isPanEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            this.m_mouseNormPosition = soEvent.getNormalizedPosition(sbViewportRegion);
            this.m_cameraInteractor.pan(this.m_mouseNormPosition, sbViewportRegion);
            soHandleEventAction.setHandled();
        }
    }

    protected void doTranslate(SoTouchEvent soTouchEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isPanEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            SbVec2i32 sbVec2i32 = sbViewportRegion.getViewportSizePixelsi32();
            SbVec2f sbVec2f = soTouchEvent.getDisplacement().over(2.0f);
            this.m_cameraInteractor.translate(new SbVec2f(sbVec2f.getX() / (float)sbVec2i32.getX(), sbVec2f.getY() / (float)sbVec2i32.getY()), sbViewportRegion);
            soHandleEventAction.setHandled();
        }
    }

    protected void doRotate(SoRotateGestureEvent soRotateGestureEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isRotateEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            SbVec2f sbVec2f = soRotateGestureEvent.getNormalizedPosition(sbViewportRegion);
            float f = this.m_cameraInteractor.getCamera().getViewVolume().getNearDist();
            SbVec3f sbVec3f = this.m_cameraInteractor.projectToPlane(sbVec2f, f, sbViewportRegion);
            this.m_cameraInteractor.setRotationAxis(new SbVec3f(0.0f, 0.0f, 1.0f));
            this.m_cameraInteractor.setRotationCenter(sbVec3f);
            this.m_cameraInteractor.rotate(-soRotateGestureEvent.getDeltaRotation() * 0.5f);
            soHandleEventAction.setHandled();
        }
    }

    protected void doRoll(SoEvent soEvent, SoHandleEventAction soHandleEventAction) {
        if (this.m_isRotateEnabled) {
            this.startInteraction();
            SbViewportRegion sbViewportRegion = soHandleEventAction.getViewportRegion();
            SbVec2f sbVec2f = soEvent.getNormalizedPosition(sbViewportRegion);
            SbVec2f sbVec2f2 = new SbVec2f(0.5f, 0.5f);
            SbVec2f sbVec2f3 = this.m_mouseNormPosition.minus(sbVec2f2);
            this.m_mouseNormPosition = sbVec2f;
            SbVec2f sbVec2f4 = this.m_mouseNormPosition.minus(sbVec2f2);
            float f = sbVec2f4.getX() == 0.0f && sbVec2f4.getY() == 0.0f ? 0.0f : (float)Math.atan2(sbVec2f4.getY(), sbVec2f4.getX());
            this.m_cameraInteractor.roll(f -= sbVec2f3.getX() == 0.0f && sbVec2f3.getY() == 0.0f ? 0.0f : (float)Math.atan2(sbVec2f3.getY(), sbVec2f3.getX()));
            if (this.m_isAutoClippingPlanes) {
                this.m_cameraInteractor.adjustClippingPlanes(soHandleEventAction.getNodeAppliedTo(), sbViewportRegion);
            }
            soHandleEventAction.setHandled();
        }
    }

    protected void interactiveCountInc() {
        ++this.m_interactiveCount;
        if (this.m_interactiveCount == 1 && this.m_currentAction != null) {
            this.m_currentAction.getSceneManager().setInteractive(true);
            this.m_currentAction.getSceneManager().scheduleRedraw();
        }
    }

    protected void interactiveCountDec() {
        if (this.m_interactiveCount > 0) {
            --this.m_interactiveCount;
            if (this.m_interactiveCount == 0 && this.m_currentAction != null) {
                this.m_currentAction.getSceneManager().setInteractive(false);
                this.m_currentAction.getSceneManager().scheduleRedraw();
            }
        }
    }

    private void startInteraction() {
        if (this.m_interactionEndSensor.isScheduled()) {
            this.m_interactionEndSensor.unschedule();
        } else {
            this.interactiveCountInc();
        }
        this.m_interactionEndSensor.setTimeFromNow(new SbTime(0.5));
        this.m_interactionEndSensor.schedule();
    }

    private class SeekAnimatorListener
    implements AnimatorListener {
        private SeekAnimatorListener() {
        }

        @Override
        public void animationStarted() {
            NavigationInteraction.this.interactiveCountInc();
        }

        @Override
        public void animationStopped() {
            NavigationInteraction.this.interactiveCountDec();
            NavigationInteraction.this.setSeekMode(false);
        }
    }

    private class InteractionEndSensorTask
    implements Runnable {
        private InteractionEndSensorTask() {
        }

        @Override
        public void run() {
            NavigationInteraction.this.interactiveCountDec();
        }
    }
}

