/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.gestures.events.SoDoubleTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoLongTapGestureEvent;
import com.openinventor.inventor.gestures.events.SoRotateGestureEvent;
import com.openinventor.inventor.gestures.events.SoScaleGestureEvent;
import com.openinventor.inventor.sensors.SoOneShotSensor;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import com.openinventor.inventor.viewercomponents.nodes.BaseInteraction;
import com.openinventor.inventor.viewercomponents.nodes.NavigationInteraction;
import com.openinventor.inventor.viewercomponents.nodes.OrbitInteraction;
import com.openinventor.inventor.viewercomponents.nodes.PlaneInteraction;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import com.openinventor.inventor.viewercomponents.nodes.SelectionInteraction;
import java.util.ArrayList;

public class SceneExaminer
extends SceneInteractor {
    private NavigationInteraction m_navigation;
    private SelectionInteraction m_selection;
    private BaseInteraction m_currentInteraction;
    private ArrayList<InteractionModeListener> m_modeListeners;
    private boolean m_isSelectionEnabled;

    public SceneExaminer() {
        this.m_navigation = new OrbitInteraction(this.m_cameraInteractor);
        this.m_currentInteraction = this.m_navigation;
        this.m_selection = new SelectionInteraction();
        this.m_modeListeners = new ArrayList();
        this.m_isSelectionEnabled = true;
    }

    @Override
    public void setCameraMode(SceneInteractor.CameraMode cameraMode) {
        super.setCameraMode(cameraMode);
        if (this.m_navigation != null) {
            this.m_navigation.setCameraInteractor(this.m_cameraInteractor);
        }
    }

    public NavigationMode getNavigationMode() {
        if (this.m_navigation instanceof OrbitInteraction) {
            return NavigationMode.ORBIT;
        }
        return NavigationMode.PLANE;
    }

    public void setNavigationMode(NavigationMode navigationMode) {
        switch (navigationMode.ordinal()) {
            case 0: {
                this.m_navigation = new OrbitInteraction(this.m_navigation);
                break;
            }
            case 1: {
                this.m_navigation = new PlaneInteraction(this.m_navigation);
                break;
            }
        }
        if (this.getInteractionMode() == InteractionMode.NAVIGATION) {
            this.m_currentInteraction = this.m_navigation;
        }
    }

    public InteractionMode getInteractionMode() {
        if (this.m_currentInteraction instanceof SelectionInteraction) {
            return InteractionMode.SELECTION;
        }
        return InteractionMode.NAVIGATION;
    }

    public void setInteractionMode(InteractionMode interactionMode) {
        if (this.getInteractionMode() != interactionMode) {
            switch (interactionMode.ordinal()) {
                case 1: {
                    this.m_navigation.reset();
                    this.m_currentInteraction = this.m_selection;
                    break;
                }
                case 0: {
                    this.m_currentInteraction = this.m_navigation;
                    break;
                }
            }
            for (InteractionModeListener interactionModeListener : this.m_modeListeners) {
                interactionModeListener.interactionModeChanged(interactionMode);
            }
        }
    }

    public void addInteractionModeListener(InteractionModeListener interactionModeListener) {
        this.m_modeListeners.add(interactionModeListener);
        this.m_navigation.m_modeListeners.add(interactionModeListener);
    }

    public void removeInteractionModeListener(InteractionModeListener interactionModeListener) {
        this.m_modeListeners.remove(interactionModeListener);
        this.m_navigation.m_modeListeners.add(interactionModeListener);
    }

    public void enableSelection(boolean bl) {
        this.m_isSelectionEnabled = bl;
    }

    public boolean isSelectionEnabled() {
        return this.m_isSelectionEnabled;
    }

    public void enableZoom(boolean bl) {
        this.m_navigation.m_isZoomEnabled = bl;
    }

    public boolean isZoomEnabled() {
        return this.m_navigation.m_isZoomEnabled;
    }

    public void enableRotate(boolean bl) {
        this.m_navigation.m_isRotateEnabled = bl;
    }

    public boolean isRotateEnabled() {
        return this.m_navigation.m_isRotateEnabled;
    }

    public void enableSeek(boolean bl) {
        this.m_navigation.m_isSeekEnabled = bl;
    }

    public boolean isSeekEnabled() {
        return this.m_navigation.m_isSeekEnabled;
    }

    public void enablePan(boolean bl) {
        this.m_navigation.m_isPanEnabled = bl;
    }

    public boolean isPanEnabled() {
        return this.m_navigation.m_isPanEnabled;
    }

    public void enableOrbit(boolean bl) {
        this.m_navigation.m_isOrbitEnabled = bl;
    }

    public boolean isOrbitEnabled() {
        return this.m_navigation.m_isOrbitEnabled;
    }

    public void setSeekMode(boolean bl) {
        if (this.getInteractionMode() == InteractionMode.NAVIGATION) {
            this.m_navigation.setSeekMode(bl);
        }
    }

    @Override
    protected void keyPressed(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        if (soKeyboardEvent.getKey() == SoKeyboardEvent.Keys.ESCAPE) {
            this.switchInteractionMode(soHandleEventAction);
            soHandleEventAction.setHandled();
        } else {
            this.m_currentInteraction.beginAction(soKeyboardEvent, soHandleEventAction);
        }
    }

    @Override
    protected void keyReleased(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.beginAction(soKeyboardEvent, soHandleEventAction);
    }

    @Override
    protected void mousePressed(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.beginAction(soMouseButtonEvent, soHandleEventAction);
    }

    @Override
    protected void mouseReleased(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.beginAction(soMouseButtonEvent, soHandleEventAction);
    }

    @Override
    protected void mouseWheelMoved(SoMouseWheelEvent soMouseWheelEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soMouseWheelEvent, soHandleEventAction);
    }

    @Override
    protected void mouseMoved(SoLocation2Event soLocation2Event, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soLocation2Event, soHandleEventAction);
    }

    @Override
    protected void touch(SoTouchEvent soTouchEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soTouchEvent, soHandleEventAction);
    }

    @Override
    protected void zoom(SoScaleGestureEvent soScaleGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soScaleGestureEvent, soHandleEventAction);
    }

    @Override
    protected void rotate(SoRotateGestureEvent soRotateGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soRotateGestureEvent, soHandleEventAction);
    }

    @Override
    protected void doubleTap(SoDoubleTapGestureEvent soDoubleTapGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.m_currentInteraction.doAction(soDoubleTapGestureEvent, soHandleEventAction);
    }

    @Override
    protected void longTap(SoLongTapGestureEvent soLongTapGestureEvent, SoHandleEventAction soHandleEventAction) {
        this.switchInteractionMode(soHandleEventAction);
        soHandleEventAction.setHandled();
    }

    private void switchInteractionMode(SoHandleEventAction soHandleEventAction) {
        if (this.getInteractionMode() == InteractionMode.SELECTION) {
            SoOneShotSensor soOneShotSensor = new SoOneShotSensor();
            soOneShotSensor.setTask(() -> {
                SoLocation2Event soLocation2Event = new SoLocation2Event();
                soLocation2Event.setEventSource(SoLocation2Event.EventSources.OTHER);
                soHandleEventAction.getSceneManager().processEvent((SoEvent)soLocation2Event);
            });
            soOneShotSensor.schedule();
            this.setInteractionMode(InteractionMode.NAVIGATION);
        } else if (this.m_isSelectionEnabled) {
            this.setInteractionMode(InteractionMode.SELECTION);
        }
    }

    public static enum NavigationMode {
        ORBIT,
        PLANE;

    }

    public static enum InteractionMode {
        NAVIGATION,
        SELECTION;

    }

    public static interface InteractionModeListener {
        public void seekModeChanged(boolean var1);

        public void interactionModeChanged(InteractionMode var1);
    }
}

