/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.nodes;

import com.openinventor.inventor.Axis;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.inventor.viewercomponents.nodes.InteractionOrbiter;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import com.openinventor.inventor.viewercomponents.nodes.SoViewingCube;

public class SceneOrbiter
extends SceneInteractor {
    private InteractionOrbiter m_interaction;
    private SoViewingCube m_viewingCube;
    private SoSwitch m_viewingCubeSwitch;
    private SoFieldSensor m_upAxisSensor;

    public SceneOrbiter() {
        this.m_interaction = new InteractionOrbiter(this.m_cameraInteractor);
        this.m_viewingCubeSwitch = new SoSwitch();
        this.m_viewingCube = new SoViewingCube();
        this.m_viewingCube.sceneCamera.setValue((SoNode)this.getCamera());
        this.m_viewingCubeSwitch.addChild((SoNode)this.m_viewingCube);
        this.m_viewingCubeSwitch.whichChild.setValue(-3);
        this.m_interaction.m_orbitMethod = RotationMethods.TURNTABLE;
        this.m_interaction.m_upAxis = Axis.Y;
        this.m_viewingCube.upAxis.setValue((Enum)Axis.Y);
        this.m_upAxisSensor = new SoFieldSensor(new Runnable(){

            @Override
            public void run() {
                SceneOrbiter.this.m_interaction.m_upAxis = (Axis)SceneOrbiter.this.m_viewingCube.upAxis.getValue(Axis.class);
            }
        });
        this.m_upAxisSensor.attach((SoField)this.m_viewingCube.upAxis);
        this.addChild((SoNode)this.m_viewingCubeSwitch);
    }

    public void setConstraintLevel(float f) {
        this.m_interaction.m_turntableConstraintLevel = f;
    }

    public float getConstraintLevel() {
        return this.m_interaction.m_turntableConstraintLevel;
    }

    public void setRotationMethod(RotationMethods rotationMethods) {
        this.m_interaction.m_orbitMethod = rotationMethods;
    }

    public RotationMethods getRotationMethod() {
        return this.m_interaction.m_orbitMethod;
    }

    public void setUpAxis(Axis axis) {
        this.m_interaction.m_upAxis = axis;
        if (this.m_viewingCube.upAxis.getValue(Axis.class) != axis) {
            this.m_viewingCube.upAxis.setValue((Enum)axis);
        }
    }

    public Axis getUpAxis() {
        return this.m_interaction.m_upAxis;
    }

    public void enableViewingCube(boolean bl) {
        this.m_viewingCubeSwitch.whichChild.setValue(bl ? -3 : -1);
    }

    public boolean isViewingCubeEnabled() {
        return this.m_viewingCubeSwitch.whichChild.getValue() == -3;
    }

    public SoViewingCube getViewingCube() {
        return this.m_viewingCube;
    }

    @Override
    public void setCameraMode(SceneInteractor.CameraMode cameraMode) {
        super.setCameraMode(cameraMode);
        if (this.m_interaction != null) {
            this.m_interaction.setCameraInteractor(this.m_cameraInteractor);
        }
        if (this.m_viewingCube != null) {
            this.m_viewingCube.sceneCamera.setValue((SoNode)this.getCamera());
        }
    }

    @Override
    protected void keyPressed(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.beginAction(soKeyboardEvent, soHandleEventAction);
    }

    @Override
    protected void keyReleased(SoKeyboardEvent soKeyboardEvent, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.beginAction(soKeyboardEvent, soHandleEventAction);
    }

    @Override
    protected void mousePressed(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.beginAction(soMouseButtonEvent, soHandleEventAction);
    }

    @Override
    protected void mouseReleased(SoMouseButtonEvent soMouseButtonEvent, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.beginAction(soMouseButtonEvent, soHandleEventAction);
    }

    @Override
    protected void mouseWheelMoved(SoMouseWheelEvent soMouseWheelEvent, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.doAction(soMouseWheelEvent, soHandleEventAction);
    }

    @Override
    protected void mouseMoved(SoLocation2Event soLocation2Event, SoHandleEventAction soHandleEventAction) {
        this.m_interaction.doAction(soLocation2Event, soHandleEventAction);
    }

    public static enum RotationMethods implements IntegerValuedEnum
    {
        TURNTABLE(0),
        TRACKBALL(1);

        private int value;

        private RotationMethods(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

