/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.io.cad;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInputParameters;
import com.openinventor.inventor.io.cad.internal.JarInitializer;
import com.openinventor.inventor.io.cad.internal.JniInitializer;

public class SoCADInputReaderParameters
extends SoInputParameters {
    public void setImportOption(ImportOption importOption) {
        boolean[] blArray = new boolean[]{importOption.importEdges, importOption.importOpenShells, importOption.importPMI, importOption.mergeFaces};
        SoCADInputReaderParameters.setImportOptionImpl(this.getNativeResourceHandle(), blArray);
    }

    private static native void setImportOptionImpl(long var0, boolean[] var2);

    public ImportOption getImportOption() {
        boolean[] blArray = SoCADInputReaderParameters.getImportOptionImpl(this.getNativeResourceHandle());
        ImportOption importOption = new ImportOption();
        importOption.importEdges = blArray[0];
        importOption.importOpenShells = blArray[1];
        importOption.importPMI = blArray[2];
        importOption.mergeFaces = blArray[3];
        return importOption;
    }

    private static native boolean[] getImportOptionImpl(long var0);

    public void setTessellationOption(TessellationOption tessellationOption) {
        double[] dArray = new double[]{tessellationOption.linearTolerance, tessellationOption.angularTolerance, tessellationOption.maxTriangleEdgesRatio};
        SoCADInputReaderParameters.setTessellationOptionImpl(this.getNativeResourceHandle(), dArray);
    }

    private static native void setTessellationOptionImpl(long var0, double[] var2);

    public TessellationOption getTessellationOption() {
        double[] dArray = SoCADInputReaderParameters.getTessellationOptionImpl(this.getNativeResourceHandle());
        TessellationOption tessellationOption = new TessellationOption();
        tessellationOption.linearTolerance = dArray[0];
        tessellationOption.angularTolerance = dArray[1];
        tessellationOption.maxTriangleEdgesRatio = dArray[2];
        return tessellationOption;
    }

    private static native double[] getTessellationOptionImpl(long var0);

    private static native void setTessellationOptionImpl2(long var0, int var2);

    private static native long ctorImpl();

    protected SoCADInputReaderParameters(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setTessellationOption() {
        this.setTessellationOption(Qualities.valueOf(Qualities.MEDIUM.getValue()));
    }

    public void setTessellationOption(Qualities qualities) {
        SoCADInputReaderParameters.setTessellationOptionImpl2(this.getNativeResourceHandle(), qualities.getValue());
    }

    public SoCADInputReaderParameters() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCADInputReaderParameters.ctorImpl());
    }

    static {
        JarInitializer.checkInit();
    }

    public static class ImportOption {
        public boolean importEdges;
        public boolean importOpenShells;
        public boolean importPMI;
        public boolean mergeFaces;
    }

    public static class TessellationOption {
        public double linearTolerance = 0.5;
        public double angularTolerance = 0.0;
        public double maxTriangleEdgesRatio = 20.0;
    }

    public static enum Qualities implements IntegerValuedEnum
    {
        LOW(Qualities.getLOW()),
        MEDIUM(Qualities.getMEDIUM()),
        HIGH(Qualities.getHIGH());

        private int value;

        private static native int getHIGHNative();

        private static int getHIGH() {
            JniInitializer.checkInit();
            return Qualities.getHIGHNative();
        }

        private Qualities(int n2) {
            this.value = n2;
        }

        private static int getMEDIUM() {
            JniInitializer.checkInit();
            return Qualities.getMEDIUMNative();
        }

        private static native int getLOWNative();

        private static int getLOW() {
            JniInitializer.checkInit();
            return Qualities.getLOWNative();
        }

        private static native int getMEDIUMNative();

        public static Qualities valueOf(int n) {
            return (Qualities)IntegerValuedEnumHelper.fromIntValue(Qualities.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }
}

