/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshviz.data;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.data.PbCell;
import com.openinventor.meshviz.graph.PbBase;
import com.openinventor.meshviz.internal.JarInitializer;
import com.openinventor.meshviz.internal.JniInitializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class PbMesh
extends PbBase {
    private static native long findContainingCellImpl1(long var0, float[] var2, float var3, float[] var4);

    private static native String getVecsSetNameImpl(long var0, int var2);

    private static native Object getDirectValuesSetImpl(long var0, int var2);

    private static native float[] getValuesSetImpl(long var0, int var2);

    private static native int getNumValuesSetImpl(long var0);

    private static native int getNumStringsSetImpl(long var0);

    private static native int getNumVecsSetImpl(long var0);

    private static native void addVecsSetImpl(long var0, int var2, Object[] var3, String var4);

    private static native String getValuesSetNameImpl(long var0, int var2);

    private static native String getStringsSetNameImpl(long var0, int var2);

    private static native long findContainingCellImpl(long var0, float[] var2, float var3, float[] var4, long var5);

    private static native boolean removeValuesSetImpl(long var0, int var2);

    private static native void removeAllStringsSetImpl(long var0);

    private static native void removeAllValuesSetImpl(long var0);

    private static native boolean removeVecsSetImpl(long var0, int var2);

    private static native boolean removeStringsSetImpl(long var0, int var2);

    private static native long getVecsSetImpl(long var0, int var2);

    private static native void setCoordinatesImpl(long var0, float[] var2, float[] var3, float[] var4);

    private static native void removeAllVecsSetImpl(long var0);

    private static native void getCoordinatesImpl(long var0, Object[] var2, Object[] var3, Object[] var4);

    private static native Object getDirectVecsSetImpl(long var0, int var2);

    private static native float getAreaImpl(long var0);

    private static native int getNumCellsImpl(long var0);

    private static native void getSmallestCellBoxImpl(long var0, int[] var2, float[] var3);

    private static native void getNodeCoordImpl(long var0, int var2, float[] var3);

    private static native int getNumNodesImpl(long var0);

    private static native boolean getMaxVecsSetImpl(long var0, int var2, float[] var3);

    private static native long getCellImpl(long var0, int var2);

    private static native float getVolumeImpl(long var0);

    private static native void addValuesSetImpl1(long var0, int var2, float[] var3, int var4, String var5);

    private static native int getValuesBindingImpl(long var0, int var2);

    private static native void addStringsSetImpl(long var0, int var2, String[] var3, String var4);

    private static native boolean getMinValuesSetImpl(long var0, int var2, float[] var3);

    private static native boolean getMinVecsSetImpl(long var0, int var2, float[] var3);

    private static native boolean getMaxValuesSetImpl(long var0, int var2, float[] var3);

    private static native void getBoundingBoxImpl(long var0, float[] var2);

    private static native boolean isDataDuplicatedImpl(long var0);

    private static native void addValuesSetImpl(long var0, int var2, float[] var3, String var4);

    private static native void getBiggestCellBoxImpl(long var0, int[] var2, float[] var3);

    protected PbMesh(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void addValuesSet(int n, float[] fArray) {
        this.addValuesSet(n, fArray, "");
    }

    public void addValuesSet(int n, float[] fArray, DataBindings dataBindings) {
        this.addValuesSet(n, fArray, dataBindings, "");
    }

    public void addStringsSet(int n, String[] stringArray) {
        this.addStringsSet(n, stringArray, "");
    }

    public void addVecsSet(int n, SbVec3f[] sbVec3fArray) {
        this.addVecsSet(n, sbVec3fArray, "");
    }

    public String getStringsSetName(int n) {
        return PbMesh.getStringsSetNameImpl(this.getNativeResourceHandle(), n);
    }

    public String getVecsSetName(int n) {
        return PbMesh.getVecsSetNameImpl(this.getNativeResourceHandle(), n);
    }

    public void addVecsSet(int n, SbVec3f[] sbVec3fArray, String string) {
        PbMesh.addVecsSetImpl(this.getNativeResourceHandle(), n, sbVec3fArray, string);
    }

    public String getValuesSetName(int n) {
        return PbMesh.getValuesSetNameImpl(this.getNativeResourceHandle(), n);
    }

    public FloatBuffer getDirectValuesSet(int n) {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)PbMesh.getDirectValuesSetImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbVec3f[] getVecsSet(int n) {
        long l = Inventor.ZeroHandle;
        l = PbMesh.getVecsSetImpl(this.getNativeResourceHandle(), n);
        return SbVec3f.toArray((long)l, (long)this.getNumNodes());
    }

    public boolean removeValuesSet(int n) {
        return PbMesh.removeValuesSetImpl(this.getNativeResourceHandle(), n);
    }

    public FloatBuffer getDirectVecsSet(int n) {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)PbMesh.getDirectVecsSetImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public float[] getValuesSet(int n) {
        return PbMesh.getValuesSetImpl(this.getNativeResourceHandle(), n);
    }

    public SbVec3f getNodeCoord(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        PbMesh.getNodeCoordImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        return sbVec3f;
    }

    public SbBox3f getBoundingBox() {
        SbBox3f sbBox3f = new SbBox3f();
        PbMesh.getBoundingBoxImpl(this.getNativeResourceHandle(), sbBox3f.array);
        return sbBox3f;
    }

    public int getNumCells() {
        return PbMesh.getNumCellsImpl(this.getNativeResourceHandle());
    }

    public float getMinValuesSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        bl = PbMesh.getMinValuesSetImpl(this.getNativeResourceHandle(), n, fArray);
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public int getNumNodes() {
        return PbMesh.getNumNodesImpl(this.getNativeResourceHandle());
    }

    public DataBindings getValuesBinding(int n) {
        return (DataBindings)IntegerValuedEnumHelper.fromIntValue(DataBindings.class, (int)PbMesh.getValuesBindingImpl(this.getNativeResourceHandle(), n));
    }

    public void addStringsSet(int n, String[] stringArray, String string) {
        PbMesh.addStringsSetImpl(this.getNativeResourceHandle(), n, stringArray, string);
    }

    public void addValuesSet(int n, float[] fArray, DataBindings dataBindings, String string) {
        PbMesh.addValuesSetImpl1(this.getNativeResourceHandle(), n, fArray, dataBindings.getValue(), string);
    }

    public boolean isDataDuplicated() {
        return PbMesh.isDataDuplicatedImpl(this.getNativeResourceHandle());
    }

    public void addValuesSet(int n, float[] fArray, String string) {
        PbMesh.addValuesSetImpl(this.getNativeResourceHandle(), n, fArray, string);
    }

    public boolean removeStringsSet(int n) {
        return PbMesh.removeStringsSetImpl(this.getNativeResourceHandle(), n);
    }

    public float getMaxValuesSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        bl = PbMesh.getMaxValuesSetImpl(this.getNativeResourceHandle(), n, fArray);
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public CellBox getBiggestCellBox() {
        CellBox cellBox = new CellBox();
        int[] nArray = new int[1];
        SbBox3f sbBox3f = new SbBox3f();
        PbMesh.getBiggestCellBoxImpl(this.getNativeResourceHandle(), nArray, sbBox3f.array);
        cellBox.bbox = sbBox3f;
        cellBox.cell_index = nArray[0];
        return cellBox;
    }

    public float getVolume() {
        return PbMesh.getVolumeImpl(this.getNativeResourceHandle());
    }

    public float getArea() {
        return PbMesh.getAreaImpl(this.getNativeResourceHandle());
    }

    public float getMinVecsSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        bl = PbMesh.getMinVecsSetImpl(this.getNativeResourceHandle(), n, fArray);
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public float getMaxVecsSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        bl = PbMesh.getMaxVecsSetImpl(this.getNativeResourceHandle(), n, fArray);
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public PbCell getCell(int n) {
        return (PbCell)ObjectManager.getManagedObjectFor(PbCell.class, (Long)PbMesh.getCellImpl(this.getNativeResourceHandle(), n));
    }

    public CellBox getSmallestCellBox() {
        CellBox cellBox = new CellBox();
        int[] nArray = new int[1];
        SbBox3f sbBox3f = new SbBox3f();
        PbMesh.getSmallestCellBoxImpl(this.getNativeResourceHandle(), nArray, sbBox3f.array);
        cellBox.bbox = sbBox3f;
        cellBox.cell_index = nArray[0];
        return cellBox;
    }

    public void removeAllVecsSet() {
        PbMesh.removeAllVecsSetImpl(this.getNativeResourceHandle());
    }

    public CoordinatesInfo getCoordinates() {
        CoordinatesInfo coordinatesInfo = new CoordinatesInfo();
        Object[] objectArray = new ByteBuffer[1];
        Object[] objectArray2 = new ByteBuffer[1];
        Object[] objectArray3 = new ByteBuffer[1];
        PbMesh.getCoordinatesImpl(this.getNativeResourceHandle(), objectArray, objectArray2, objectArray3);
        if (objectArray[0] != null) {
            ((ByteBuffer)objectArray[0]).order(ByteOrder.nativeOrder());
        }
        if (objectArray2[0] != null) {
            ((ByteBuffer)objectArray2[0]).order(ByteOrder.nativeOrder());
        }
        if (objectArray3[0] != null) {
            ((ByteBuffer)objectArray3[0]).order(ByteOrder.nativeOrder());
        }
        coordinatesInfo.xnod = objectArray[0] != null ? ((ByteBuffer)objectArray[0]).asFloatBuffer() : null;
        coordinatesInfo.ynod = objectArray2[0] != null ? ((ByteBuffer)objectArray2[0]).asFloatBuffer() : null;
        coordinatesInfo.znod = objectArray3[0] != null ? ((ByteBuffer)objectArray3[0]).asFloatBuffer() : null;
        return coordinatesInfo;
    }

    public void removeAllStringsSet() {
        PbMesh.removeAllStringsSetImpl(this.getNativeResourceHandle());
    }

    public boolean removeVecsSet(int n) {
        return PbMesh.removeVecsSetImpl(this.getNativeResourceHandle(), n);
    }

    public void removeAllValuesSet() {
        PbMesh.removeAllValuesSetImpl(this.getNativeResourceHandle());
    }

    public int getNumValuesSet() {
        return PbMesh.getNumValuesSetImpl(this.getNativeResourceHandle());
    }

    public int getNumVecsSet() {
        return PbMesh.getNumVecsSetImpl(this.getNativeResourceHandle());
    }

    public ContainingCell findContainingCell(SbVec3f sbVec3f, float f, PbCell pbCell) {
        ContainingCell containingCell = new ContainingCell();
        SbVec3f sbVec3f2 = new SbVec3f();
        containingCell.cell = (PbCell)ObjectManager.getManagedObjectFor(PbCell.class, (Long)PbMesh.findContainingCellImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f, sbVec3f2 != null ? sbVec3f2.array : null, pbCell != null ? pbCell.getNativeResourceHandle() : Inventor.ZeroHandle));
        containingCell.pcoord = sbVec3f2;
        return containingCell;
    }

    public ContainingCell findContainingCell(SbVec3f sbVec3f, float f) {
        ContainingCell containingCell = new ContainingCell();
        SbVec3f sbVec3f2 = new SbVec3f();
        containingCell.cell = (PbCell)ObjectManager.getManagedObjectFor(PbCell.class, (Long)PbMesh.findContainingCellImpl1(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f, sbVec3f2 != null ? sbVec3f2.array : null));
        containingCell.pcoord = sbVec3f2;
        return containingCell;
    }

    public void setCoordinates(float[] fArray, float[] fArray2, float[] fArray3) {
        PbMesh.setCoordinatesImpl(this.getNativeResourceHandle(), fArray, fArray2, fArray3);
    }

    public int getNumStringsSet() {
        return PbMesh.getNumStringsSetImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    public static enum DataBindings implements IntegerValuedEnum
    {
        PER_CELL(DataBindings.getPERCELL()),
        PER_NODE(DataBindings.getPERNODE());

        private int value;

        private static int getPERNODE() {
            JniInitializer.checkInit();
            return DataBindings.getPERNODENative();
        }

        private DataBindings(int n2) {
            this.value = n2;
        }

        private static native int getPERNODENative();

        private static native int getPERCELLNative();

        private static int getPERCELL() {
            JniInitializer.checkInit();
            return DataBindings.getPERCELLNative();
        }

        public static DataBindings valueOf(int n) {
            return (DataBindings)IntegerValuedEnumHelper.fromIntValue(DataBindings.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class CellBox {
        public int cell_index;
        public SbBox3f bbox;

        static {
            JniInitializer.checkInit();
        }
    }

    public static class CoordinatesInfo {
        public FloatBuffer xnod;
        public FloatBuffer ynod;
        public FloatBuffer znod;

        static {
            JniInitializer.checkInit();
        }
    }

    public static class ContainingCell {
        public SbVec3f pcoord;
        public PbCell cell;

        static {
            JniInitializer.checkInit();
        }
    }
}

