/* !!GLSL Vertex Shader */

//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

uniform float AnimStep;

void main()
{
  vec4 tmp = OivVertexPosition();

  // Modification of the z and y coordinates of the vertex to create the movement
  tmp.z = sin(2.0 * tmp.x - AnimStep) * (tmp.x / 10.0);
  tmp.y = tmp.y + cos(2.0 * tmp.z) / 5.0;

  // Setting of the output position of the vertex
  gl_Position = OivModelViewProjectionMatrix() * tmp;

  // Texture coordinates
  OivSetTexCoord(0, OivVertexTextureCoordinate(0));
}
