package inventor.advanced.headlight;
import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;
import util.editors.DirectionalLightEditor;

/**
  * Use of the directional light editor
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */
public class Main extends Example {

  private IViewerExaminer myViewer;
  private DirectionalLightEditor editor;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Head Light");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator sep = readSceneGraph("$OIVJHOME/data/models/spongetri4.iv");
    SoSeparator root = new SoSeparator();
    root.addChild(sep);

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    editor = new DirectionalLightEditor() ;

    SoSearchAction searchAction = new SoSearchAction();
    searchAction.setNodeClass(SoDirectionalLight.class);
    searchAction.apply(myViewer.getRenderArea().getSceneInteractor());
    SoPath path = searchAction.getPath();
    if ( path == null )
    {
      System.err.println("Headlight not found");
    }
    else
    {
      editor.attach(path) ;
      editor.pack() ;
      editor.setVisible(true) ;
    }

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    editor.dispose();
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

}
