package inventor.advanced.offscreenRendering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoOffscreenRenderArea;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.helpers.SbFileHelper;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoImageBackground;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * This demo shows how to use the OffscreenRenderArea
 *
 * Copyright &copy; FEI SAS. All rights reserved.
 */

public class Main extends Example
{

  private IViewerExaminer myViewer;
  private SoOffscreenRenderArea offscreenRenderArea = new SoOffscreenRenderArea();
  private SoSwitch background = new SoSwitch();

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Offscreen Rendering");
  }

  public SoSeparator buildSceneGraph()
  {
    SoSeparator root = new SoSeparator();
    { // assemble scene graph

      SoImageBackground pebbles = new SoImageBackground();
      pebbles.filename.set("$OIVJHOME/data/textures/misc/n036.rgb");
      background.addChild(pebbles);
      SoImageBackground stone = new SoImageBackground();
      stone.filename.set("$OIVJHOME/data/textures/misc/n081.rgb");
      background.addChild(stone);
      background.whichChild.setValue(1);
      root.addChild(background);

      SoMaterial myMaterial = new SoMaterial();
      myMaterial.transparency.setValue(0.5f);
      root.addChild(myMaterial);
      root.addChild(new SoCube());
      root.addChild(new SoMaterial());
      root.addChild(new SoCone());

    }
    return root;
  }

  public void buildSouthPanel()
  {
    final JButton generate_button = new JButton("Generate file");

    final String[] formats = { "JPEG", "PNG", "PostScript", "RGB", "TIFF", "BMP" };
    final JComboBox<String> format_combobox = new JComboBox<>(formats);
    format_combobox.setPreferredSize(new Dimension(145, 20));
    format_combobox.setSelectedItem("PNG");

    final SliderPanel outputWidth_slider = new SliderPanel(0, 10000, 1600, false);
    outputWidth_slider.addInfoText("Output width");

    final SliderPanel outputHeigth_slider = new SliderPanel(0, 10000, 1200, false);
    outputHeigth_slider.addInfoText("Output height");

    final JCheckBox generateSubtiles_checkbox = new JCheckBox("Generate subtiles", true);

    final SliderPanel tileWidth_slider = new SliderPanel(0, 16000, 512, false);
    tileWidth_slider.addInfoText("Tile width");

    final SliderPanel tileHeigth_slider = new SliderPanel(0, 16000, 512, false);
    tileHeigth_slider.addInfoText("Tile height");

    final JCheckBox exportBackground_checkbox = new JCheckBox("Export background", false);

    final String[] backgrounds = { "NONE", "pebbles", "stone" };
    final JComboBox<String> background_combobox = new JComboBox<>(backgrounds);
    background_combobox.setPreferredSize(new Dimension(145, 20));
    background_combobox.setSelectedItem("stone");
    background_combobox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent arg0)
      {
        int index = background_combobox.getSelectedIndex();
        if ( index == 0 )
        {
          index = -1;
        }
        else
        {
          index -= 1;
        }
        background.whichChild.setValue(index);
      }
    });

    final TransparencyTypes[] transparencies = { TransparencyTypes.NO_SORT, TransparencyTypes.OPAQUE_FIRST,
        TransparencyTypes.SORTED_OBJECT, TransparencyTypes.SORTED_PIXEL };
    final JComboBox<TransparencyTypes> transparency_combobox = new JComboBox<TransparencyTypes>(transparencies);
    transparency_combobox.setPreferredSize(new Dimension(145, 20));
    transparency_combobox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent arg0)
      {
        myViewer.getRenderArea()
            .setTransparencyType(transparency_combobox.getItemAt(transparency_combobox.getSelectedIndex()));
      }
    });
    transparency_combobox.setSelectedItem(TransparencyTypes.OPAQUE_FIRST);

    final SliderPanel antialiasing_slider = new SliderPanel(0.f, 1f, 1f, 0);
    antialiasing_slider.addInfoText("Antialiasing quality");

    generate_button.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent arg0)
      {
        SbVec2i32 offscreenSize =
            new SbVec2i32((int) outputWidth_slider.getSliderValue(), (int) outputHeigth_slider.getSliderValue());
        offscreenRenderArea.setViewportRegion(new SbViewportRegion(offscreenSize));

        SbVec2i32 offscreenTileSize = offscreenSize;
        if ( generateSubtiles_checkbox.isSelected() )
        {
          offscreenTileSize =
              new SbVec2i32((int) tileWidth_slider.getSliderValue(), (int) tileHeigth_slider.getSliderValue());
        }
        offscreenRenderArea.setTile(offscreenTileSize, 4);

        offscreenRenderArea
            .setTransparencyType(transparency_combobox.getItemAt(transparency_combobox.getSelectedIndex()));

        offscreenRenderArea.getSceneManager().setAntialiasing(antialiasing_slider.getSliderValue());

        final int oldBackground = background.whichChild.getValue();
        if ( !exportBackground_checkbox.isSelected() )
        {
          background.whichChild.setValue(-1);
        }

        offscreenRenderArea.renderToFile(
            SbFileHelper.expandString("$OIVJHOME/examples/inventor/advanced/offscreenRendering/offscreen_out.")
                + formats[format_combobox.getSelectedIndex()]);

        if ( !exportBackground_checkbox.isSelected() )
        {
          background.whichChild.setValue(oldBackground);
        }
      }
    });

    JPanel bottomPanel = new JPanel(new GridLayout(0, 1));
    bottomPanel.add(generate_button);
    bottomPanel.add(format_combobox);
    bottomPanel.add(outputWidth_slider);
    bottomPanel.add(outputHeigth_slider);
    bottomPanel.add(generateSubtiles_checkbox);
    bottomPanel.add(tileWidth_slider);
    bottomPanel.add(tileHeigth_slider);
    bottomPanel.add(background_combobox);
    bottomPanel.add(exportBackground_checkbox);
    bottomPanel.add(transparency_combobox);
    bottomPanel.add(antialiasing_slider);

    add(bottomPanel, BorderLayout.SOUTH);
  }

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator root = buildSceneGraph();

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    // if there is no camera, add one to make a viewAll
    // and ensure the capture has something in view
    SoSearchAction sa = new SoSearchAction();
    sa.setNodeClass(SoCamera.class);
    sa.apply(root);
    SoPath pCamPath = sa.getPath();
    if ( pCamPath == null )
    {
      SoSeparator scene = root;
      root = new SoSeparator();
      root.addChild(myViewer.getRenderArea().getSceneInteractor().getCamera());
      root.addChild(new SoDirectionalLight());
      root.addChild(scene);
    }

    offscreenRenderArea.setSceneGraph(root);

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);

    buildSouthPanel();
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

}
