package inventor.advanced.overlayPanels;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.actions.SoHaloHighlightRenderAction;
import com.openinventor.inventor.misc.callbacks.SoSelectionClassCB;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderAreaOrbiter;

import util.Example;

public class Main extends Example
{
  private RenderAreaOrbiter renderArea;

  @Override
  public void start()
  {
    renderArea = new RenderAreaOrbiter();
    renderArea.setPreferredSize(new java.awt.Dimension(1600, 900));
    setLayout(new BorderLayout());
    add(renderArea);

    // Scene graph
    SceneOverlayPanels scene = new SceneOverlayPanels();
    var root = scene.getSceneGraph();

    renderArea.setSceneGraph(root);

    var highlightAction = new SoHaloHighlightRenderAction();
    highlightAction.setHaloAlwaysVisible(true);
    renderArea.setGLRenderAction(highlightAction);
    renderArea.setAntialiasingMode(AntialiasingModes.AUTO);
    renderArea.setAntialiasingQuality(1);
    
    // Add a callback on selection to redraw the scene and show
    // the highlight directly after picking a shape.
    root.addChangeCallback(new SoSelectionClassCB()
    {
      @Override
      public void invoke(SoSelection s)
      {
        renderArea.scheduleRedraw();
      }
    });

    renderArea.viewAll(new SbViewportRegion());
  }

  @Override
  public void stop()
  {
    renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("OverlayPanels");
  }

}