//!oiv_include <Inventor/oivShaderVariables.h>
//!oiv_include <Inventor/oivShaderState.h>

in vec3 vPos;
in vec4 vColor;
in vec3 vNormal;

void main()
{  
  vec2 pc = 2.0*gl_PointCoord.st - 1.0;
  if (dot(pc, pc) > 1.0)
    discard;

  vec4 finalColor = vec4(1.0);

  if (vColor.x < 1.0)
    finalColor.rgb = mix(vec3(1.0, 1.0, 1.0), vec3(0.0, 0.0, 1.0), smoothstep(0.0, 1.0, vColor.x));
  else
    finalColor.rgb = mix(vec3(0.0, 0.0, 1.0), vec3(1.0, 0.0, 0.0), smoothstep(0.0, 32.0, vColor.x));
  
  float factor = abs(dot(normalize(vNormal), vec3(0.0, 0.0, 1.0)));
  
  OivFragmentOutput( factor * finalColor );
}
