/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 7, example 1.
 *
 *  This example displays a textured cube (default
 *  texture coords).
 *------------------------------------------------------------*/


package inventor.mentor.basicTexture;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTexture2;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Basic Texture");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Choose a texture
    SoTexture2 rock = new SoTexture2();
    rock.filename.setValue("$OIVJHOME/data/textures/rgb/brick.1.rgb");

    SoSeparator root = new SoSeparator();
    { //Assemble scene graph
      root.addChild(rock);
      // Make a cube
      root.addChild(new SoCube());
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
