/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 8.
 *
 *  Blinker node.
 *  Use a blinker node to flash a neon ad sign on and off
 *------------------------------------------------------------*/


package inventor.mentor.blinker;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoBlinker;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IRenderAreaInteractive myRenderArea;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Neon");
  }

  @Override
  public void start() {
    myRenderArea = ViewerComponentsFactory.createRenderAreaInteractive();

    // Read in the parts of the sign from a file
    SoInput myInput = new SoInput();
    String filename = "$OIVJHOME/data/models/eatAtJosies.iv";
    if (!myInput.openFile(filename)) {
      System.err.println("Cannot open file " + filename);
      System.exit(1);
    }
    SoSeparator fileContents = SoDB.readAll(myInput);
    if (fileContents == null) {
      System.err.println("Cannot read file " + filename);
      System.exit(1);
    }

    SoSeparator eatAt = (SoSeparator)SoNode.getByName("EatAt");
    SoSeparator josie = (SoSeparator)SoNode.getByName("Josies");
    SoSeparator frame = (SoSeparator)SoNode.getByName("Frame");

    //////////////////////////////////////////////////////////////
    // CODE FOR The Inventor Mentor STARTS HERE

    // Add the fast-blinking part to a blinker node
    SoBlinker fastBlinker = new SoBlinker();
    fastBlinker.speed.setValue(2);  // blinks 2 times a second
    fastBlinker.addChild(josie);

    // Add the slow-blinking part to another blinker node
    SoBlinker slowBlinker = new SoBlinker();
    slowBlinker.speed.setValue(0.5f);  // 2 secs per cycle; 1 on, 1 off
    slowBlinker.addChild(frame);

    // CODE FOR The Inventor Mentor ENDS HERE
    //////////////////////////////////////////////////////////////

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
       // Add the non-blinking part of the sign to the root
       root.addChild(eatAt);
       root.addChild(fastBlinker);
       root.addChild(slowBlinker);
    }

    final Component canvas = myRenderArea.getComponent();

    // Set up and display render area
    SbViewportRegion myRegion = new SbViewportRegion(canvas.getSize());
    myRenderArea.setSceneGraph(root);
    myRenderArea.viewAll(myRegion);

    canvas.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    myRenderArea.dispose();
  }
}
