/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 6, example 3.
 *
 *  This example renders arguments as text within an
 *  examiner viewer.  It is a little fancier than 6.2.
 *------------------------------------------------------------*/

package inventor.mentor.complex3DText;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Complex 3D Text");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Set up camera
    SoCamera camera = myViewer.getRenderArea().getSceneInteractor().getCamera();
    camera.nearDistance.setValue(5.0f);
    camera.farDistance.setValue(15.0f);

    // Let's make the front of the text white,
    // and the sides and back shiny yellow
    SoMaterial myMaterial = new SoMaterial();
    // diffuse
    SbColor[] colors = {
        new SbColor(1, 1, 1),
        new SbColor(1, 1, 0),
        new SbColor(1, 1, 0)
    };
    myMaterial.diffuseColor.setValues(0, colors);

    // specular
    myMaterial.specularColor.setValue(colors[0]);

    myMaterial.shininess.setValue(0.1f);

    // Choose a font likely to exist.
    SoFont myFont = new SoFont();

    // Specify a beveled cross-section for the text
    SoProfileCoordinate2 myProfileCoords = new SoProfileCoordinate2();
    SbVec2f[] coords = {
        new SbVec2f(0.00f, 0.00f),
        new SbVec2f(0.25f, 0.25f),
        new SbVec2f(1.25f, 0.25f),
        new SbVec2f(1.50f, 0.00f)
    };
    myProfileCoords.point.setValues(0, coords);

    SoLinearProfile myLinearProfile = new SoLinearProfile();
    int[] index = {0, 1, 2, 3};
    myLinearProfile.index.setValues(0, index);

    // Set the material binding to PER_PART
    SoMaterialBinding myMaterialBinding = new SoMaterialBinding();
    myMaterialBinding.value.setValue(SoMaterialBinding.Bindings.PER_PART);

    // Add the text
    SoText3 myText3 = new SoText3();
    myText3.string.setValue("Beveled Text");
    myText3.justification.setValue(SoText3.Justifications.CENTER);
    myText3.parts.setValue(SoText3.PartType.ALL);

    SoGroup root = new SoGroup();
    { // Assemble scene graph
      root.addChild(myMaterial);
      root.addChild(myFont);
      root.addChild(myProfileCoords);
      root.addChild(myLinearProfile);
      root.addChild(myMaterialBinding);
      root.addChild(myText3);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
