/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 4, example 2.
 *
 *  Lights example.
 *  Read in an object from a file.
 *  Use the SimpleViewer to view it with two light sources.
 *  The red directional light doesn't move; the green point
 *  light is moved back and forth using a shuttle node.
 *------------------------------------------------------------*/

package inventor.mentor.lights;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoPointLight;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShuttle;
import com.openinventor.inventor.nodes.SoTransformSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Lights");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Add a directional light
    SoDirectionalLight myDirLight = new SoDirectionalLight();
    myDirLight.direction.setValue(0, -1, -1);
    myDirLight.color.setValue(1, 0, 0);

    // Put the shuttle and the light below a transform separator.
    // A transform separator pushes and pops the transformation
    // just like a separator node, but other aspects of the state
    // are not pushed and popped. So the shuttle's translation
    // will affect only the light. But the light will shine on
    // the rest of the scene.
    SoTransformSeparator myTransformSeparator =
        new SoTransformSeparator();

    // A shuttle node translates back and forth between the two
    // fields translation0 and translation1.
    // This moves the light.
    SoShuttle myShuttle = new SoShuttle();
    myTransformSeparator.addChild(myShuttle);
    myShuttle.translation0.setValue( -2, -1, 3);
    myShuttle.translation1.setValue(1, 2, -3);

    // Add the point light below the transformSeparator
    SoPointLight myPointLight = new SoPointLight();
    myTransformSeparator.addChild(myPointLight);
    myPointLight.color.setValue(0, 1, 0);

    SoSeparator root = new SoSeparator();
    { //Assemble scene graph
      root.addChild(myDirLight);
      root.addChild(myTransformSeparator);
      root.addChild(new SoCone());
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
