package inventor.mentor.molecule; import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  mentor.Molecule example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */


public class Main extends Example {

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Molecule");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    SoGroup waterMolecule = new SoGroup();
    SoGroup oxygen = new SoGroup();
    SoMaterial redPlastic = new SoMaterial();
    SoSphere sphere1 = new SoSphere();

    SoGroup hydrogen1 = new SoGroup();
    SoGroup hydrogen2 = new SoGroup();
    SoTransform hydrogenXform1 = new SoTransform();
    SoTransform hydrogenXform2 = new SoTransform();
    SoMaterial whitePlastic = new SoMaterial();
    SoSphere sphere2 = new SoSphere();
    SoSphere sphere3 = new SoSphere();

    // Set all field values for the oxygen atom
    redPlastic.ambientColor.setValue(1.0F,0.0F,0.0F);
    redPlastic.diffuseColor.setValue(1.0F,0.0F,0.0F);
    redPlastic.specularColor.setValue(0.5F,0.5F,0.5F);
    redPlastic.shininess.setValue(0.5F);

    // Set all field values for the hydrogen atom
    hydrogenXform1.scaleFactor.setValue(0.75F,0.75F,0.75F);
    hydrogenXform1.translation.setValue(0.0F,-1.2F,0.0F);
    hydrogenXform2.translation.setValue(1.1852F,1.3877F,0.0F);

    whitePlastic.ambientColor.setValue(1.0F,1.0F,1.0F);
    whitePlastic.diffuseColor.setValue(1.0F,1.0F,1.0F);
    whitePlastic.specularColor.setValue(0.5F,0.5F,0.5F);
    whitePlastic.shininess.setValue(0.5F);

    // Create a hierarchy
    waterMolecule.addChild(oxygen);
    waterMolecule.addChild(hydrogen1);
    waterMolecule.addChild(hydrogen2);

    oxygen.addChild(redPlastic);
    oxygen.addChild(sphere1);
    hydrogen1.addChild(hydrogenXform1);
    hydrogen1.addChild(whitePlastic);
    hydrogen1.addChild(sphere2);
    hydrogen2.addChild(hydrogenXform2);
    hydrogen2.addChild(whitePlastic);
    hydrogen2.addChild(sphere3);

    SoSeparator root = new SoSeparator() ;
    root.addChild(waterMolecule) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
