package inventor.mentor.naming;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 3.
 *
 *  Create a little scene graph and then name some nodes and
 *  get back nodes by name.
 *------------------------------------------------------------*/
public class Main extends Example
{

  private IViewerExaminer myViewer;

  void removeCube()
  {
    // Remove the cube named 'MyCube' from the separator named
    // 'Root'. In a real application, instanceof would probably
    // be used to make sure the nodes are of the correct type
    // before doing the cast.

    SoSeparator myRoot = (SoSeparator) SoNode.getByName("Root");
    SoCube myCube = (SoCube) SoNode.getByName("MyCube");

    myRoot.removeChild(myCube);
  }

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create some objects and give them names:
    SoSeparator root = new SoSeparator();
    root.setName("Root");

    SoCube myCube = new SoCube();
    root.addChild(myCube);
    myCube.setName("MyCube");

    SoSphere mySphere = new SoSphere();
    root.addChild(mySphere);
    mySphere.setName("MySphere");

    removeCube();

    // attach and show viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Naming nodes");
  }
}
