/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 12, example 2.
 *
 *  Using getTriggerNode/getTriggerField methods of the data
 *  sensor.
 *------------------------------------------------------------*/

package inventor.mentor.nodeSensor;

import java.awt.BorderLayout;

import javax.swing.JTextArea;

import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.sensors.SoNodeSensor;

import util.Example;

public class Main extends Example {

  private JTextArea m_txtArea = new JTextArea();
  private SoNodeSensor m_sensor;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Node Sensor");
  }

  @Override
  public void start() {
    SoCube myCube = new SoCube();
    myCube.setName("MyCube");

    SoSphere mySphere = new SoSphere();
    mySphere.setName("MySphere");

    SoSeparator root = new SoSeparator();
    root.setName("Root");
    {
      root.addChild(myCube);
      root.addChild(mySphere);
    }

    m_sensor = new SoNodeSensor(new RootChangedRunnable());
    m_sensor.setPriority(0);
    m_sensor.attach(root);

    // Now, make a few changes to the scene graph; the sensor's
    // callback function will be called immediately after each
    // change.
    myCube.width.setValue(1.0f);
    myCube.height.setValue(2.0f);
    mySphere.radius.setValue(3.0f);
    root.removeChild(mySphere);

    m_txtArea.setEditable(false);

    setLayout(new BorderLayout());
    add(m_txtArea);
  }

  @Override
  public void stop()
  {}

  class RootChangedRunnable implements Runnable {
    @Override
    public void run() {
      SoNode changedNode = m_sensor.getTriggerNode();
      SoField changedField = m_sensor.getTriggerField();

      m_txtArea.append("The node named '"+changedNode.getName()+"' changed\n");

      if (changedField != null)
        m_txtArea.append(" (field "+changedNode.getFieldName(changedField)+")\n\n");
      else
        m_txtArea.append(" (no fields changed)\n");
    }
  }
}
