/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 9, example 3.
 *
 *  Search Action example.
 *  Read in a scene from a file.
 *  Search through the scene looking for a light.
 *  If none exists, add a directional light to the scene
 *  and print out the modified scene.
 *-----------------------------------------------------------*/

package inventor.mentor.search;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoOutput;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoLight;
import com.openinventor.inventor.nodes.SoSeparator;

import util.Example;

public class Main extends Example
{

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Search");
  }

  @Override
  public void start() {

    try {
      // Create first the scroll pane
      JEditorPane pane = new JEditorPane();
      JScrollPane jsp = new JScrollPane(pane);
      jsp.setPreferredSize(new Dimension(600, 700));

      // Open and read input scene graph
      SoInput sceneInput = new SoInput();
      String filename = "$OIVJHOME/data/models/bird.iv";
      if (!sceneInput.openFile(filename)) {
        System.err.println("Could not open file " + filename);
        System.exit(1);
      }

      SoSeparator root = SoDB.readAll(sceneInput);
      if (root == null)
        System.exit(1);

      //////////////////////////////////////////////////////////////
      // CODE FOR The Inventor Mentor STARTS HERE

      SoSearchAction mySearchAction = new SoSearchAction();

      // Look for first existing light derived from class SoLight
      mySearchAction.setNodeClass(SoLight.class, true);
      mySearchAction.setInterest(SoSearchAction.Interests.FIRST);

      mySearchAction.apply(root);
      if (mySearchAction.getPath() == null) { // No lights found
        // Add a default directional light to the scene
        SoDirectionalLight myLight = new SoDirectionalLight();
        root.insertChild(myLight, 0);
      }

      // CODE FOR The Inventor Mentor ENDS HERE
      //////////////////////////////////////////////////////////////

      SoOutput out = new SoOutput();
      String out_filename = "out.txt";
      out.openFile(out_filename);
      System.out.println("Printing...");
      SoWriteAction myWriteAction = new SoWriteAction(out);
      myWriteAction.apply(root);
      System.out.println("...done printing");
      out.closeFile();

      pane.setPage("file:" + out_filename);
      pane.setEditable(false);

      setLayout(new BorderLayout());
      add(jsp);
    }
    catch (Exception e) {
      System.out.println(e);
    }

  }

  @Override
  public void stop()
  {}
}
