package inventor.mentor.trackball;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.manips.SoTrackballManip;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *  mentor.Trackball example program;
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Trackball");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoMaterial myMaterial = new SoMaterial() ;
    myMaterial.diffuseColor.setValue(1, 0, 0) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(new SoTrackballManip());
      root.addChild(myMaterial);
      root.addChild(new SoCone());
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
