/*--------------------------------------------------------------
*  This is an example from the Inventor Mentor,
*  chapter 5, example 6.
*
*  This example shows the effect of different order of
*  operation of transforms.  The left object is first
*  scaled, then rotated, and finally translated to the left.
*  The right object is first rotated, then scaled, and finally
*  translated to the right.
*------------------------------------------------------------*/

package inventor.mentor.transformOrdering;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoScale;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Transform Ordering");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Create two separators, for left and right objects.
    SoSeparator leftSep = new SoSeparator();
    SoSeparator rightSep = new SoSeparator();

    // Create the transformation nodes
    SoTranslation leftTranslation = new SoTranslation();
    SoTranslation rightTranslation = new SoTranslation();
    SoRotationXYZ myRotation = new SoRotationXYZ();
    SoScale myScale = new SoScale();

    // Fill in the values
    leftTranslation.translation.setValue(-1.0f, 0.0f, 0.0f);
    rightTranslation.translation.setValue(1.0f, 0.0f, 0.0f);
    myRotation.angle.setValue((float)java.lang.Math.PI / 2.0f); // 90 degrees
    myRotation.axis.setValue(SoRotationXYZ.AxisType.X);
    myScale.scaleFactor.setValue(2.0f, 1.0f, 3.0f);

    // Read an object from file. (as in example 4.2.Lights)
    SoInput myInput = new SoInput();
    if ( !myInput.openFile("$OIVJHOME/data/models/temple.iv") )
      System.exit(1);
    SoSeparator fileContents = SoDB.readAll(myInput);
    if (fileContents == null)
      System.exit(1);

    SoSeparator root = new SoSeparator();
    { // Assemble scene graph
      root.addChild(leftSep);
      root.addChild(rightSep);

      // Add transforms to the scene.
      leftSep.addChild(leftTranslation); // left graph
      leftSep.addChild(myRotation); // then rotated
      leftSep.addChild(myScale); // first scaled

      rightSep.addChild(rightTranslation); // right graph
      rightSep.addChild(myScale); // then scaled
      rightSep.addChild(myRotation); // first rotated

      // Add an instance of the object under each separator.
      leftSep.addChild(fileContents);
      rightSep.addChild(fileContents);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
