package inventor.sample.annotation2D_1;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoResetTransform;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Root node of scene graph
    // 3D (application) and 2D (annotation) scene graphs below this.
    SoSeparator root = new SoSeparator();

    // Try to read the file in 3D Root separator
    SoSeparator sep3d = readSceneGraph("$OIVJHOME/data/models/spongetri4.iv");
    root.addChild(sep3d);

    // Create 2D scene root and camera (usually orthographic)
    SoSeparator sep2d = new SoSeparator();
    SoOrthographicCamera cam2d = new SoOrthographicCamera();

    // Font settings and material for 2D annotations
    SoFont font1 = new SoFont();
    font1.name.setValue("Arial");
    font1.size.setValue(20);
    font1.renderStyle.setValue(SoFont.RenderStyles.TEXTURE);
    SoMaterial matl1 = new SoMaterial();
    matl1.diffuseColor.setValue(new SbColor(1, 1, 1));

    // Build basic 2D scene
    root.addChild(sep2d);
    sep2d.addChild(cam2d);
    sep2d.addChild(font1);
    sep2d.addChild(matl1);

    // Create some 2D annotations
    SoSeparator textSep1 = new SoSeparator();
    SoTranslation tran1 = new SoTranslation();
    SoText2 text1 = new SoText2();
    tran1.translation.setValue(new SbVec3f(-.99f, .9f, 0));
    text1.string.setValue("Upper Left");
    textSep1.addChild(tran1);
    textSep1.addChild(text1);
    sep2d.addChild(textSep1);

    SoSeparator textSep2 = new SoSeparator();
    SoTranslation tran2 = new SoTranslation();
    SoText2 text2 = new SoText2();
    tran2.translation.setValue(new SbVec3f(-.99f, -.95f, 0));
    text2.string.setValue("Lower Left");
    textSep2.addChild(tran2);
    textSep2.addChild(text2);
    sep2d.addChild(textSep2);

    SoSeparator textSep3 = new SoSeparator();
    SoTranslation tran3 = new SoTranslation();
    SoText2 text3 = new SoText2();
    tran3.translation.setValue(new SbVec3f(.99f, -.95f, 0));
    text3.string.setValue("Lower Right");
    text3.justification.setValue(SoText2.Justifications.RIGHT);
    textSep3.addChild(tran3);
    textSep3.addChild(text3);
    sep2d.addChild(textSep3);

    // Finally... We don't want the extent of the annotations to affect
    // a "viewAll" of the application geometry. So we'll "reset" the
    // accumulated bounding box during traveral of the annotation scene.
    SoResetTransform resetBbox = new SoResetTransform();
    resetBbox.whatToReset.setValue(SoResetTransform.ResetTypes.BBOX);
    sep2d.addChild(resetBbox);

    // Load the scene graph and adjust the 3D camera to view entire scene.
    // Don't forget to save this as the Home position!
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("2D Annotation");
  }
}
