package inventor.sample.annotation3D_BBox;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoIndexedLineSet;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  SoSeparator makeBBox(SbBox3f box, SbColor color, float width)
  {
    // The box will be easier to see without lighting
    SoLightModel lModel = new SoLightModel();
    lModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    // And with wide lines
    SoDrawStyle style = new SoDrawStyle();
    style.lineWidth.setValue(width);

    // The box should be unpickable
    // (so geometry inside can be picked, draggers work inside, etc)
    SoPickStyle pickable = new SoPickStyle();
    pickable.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    // Create a cube outlining the specified box
    float[] bounds = box.getBounds();
    float xmin = bounds[0];
    float ymin = bounds[1];
    float zmin = bounds[2];
    float xmax = bounds[3];
    float ymax = bounds[4];
    float zmax = bounds[5];

    SoVertexProperty prop = new SoVertexProperty();
    prop.vertex.set1Value(0, new SbVec3f(xmin, ymin, zmin));
    prop.vertex.set1Value(1, new SbVec3f(xmax, ymin, zmin));
    prop.vertex.set1Value(2, new SbVec3f(xmax, ymax, zmin));
    prop.vertex.set1Value(3, new SbVec3f(xmin, ymax, zmin));
    prop.vertex.set1Value(4, new SbVec3f(xmin, ymin, zmax));
    prop.vertex.set1Value(5, new SbVec3f(xmax, ymin, zmax));
    prop.vertex.set1Value(6, new SbVec3f(xmax, ymax, zmax));
    prop.vertex.set1Value(7, new SbVec3f(xmin, ymax, zmax));
    prop.orderedRGBA.set1Value(0, color.getPackedValue());

    // Draw it with a line set
    int coordIndices[] = { 0, 1, 2, 3, 0, -1, 4, 5, 6, 7, 4, -1,
                           0, 4, -1, 1, 5, -1, 2, 6, -1, 3, 7 };
    SoIndexedLineSet lines = new SoIndexedLineSet();
    lines.vertexProperty.setValue(prop);
    lines.coordIndex.setValues(0, coordIndices);

    // Assemble scene graph
    SoSeparator boxSep = new SoSeparator();
    boxSep.addChild(lModel);
    boxSep.addChild(pickable);
    boxSep.addChild(style);
    boxSep.addChild(lines);
    return boxSep;
  }

  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Load some volume data
    SoVolumeData volData = new SoVolumeData();
    volData.fileName.setValue("$OIVJHOME/data/volumeviz/SYN_64.VOL");

    // Use a predefined colorMap
    // Set the first entry in the colormap to be transparent (alpha = 0)
    SoTransferFunction transFunc = new SoTransferFunction();
    transFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.BLUE_WHITE_RED);
    transFunc.actualColorMap.set1Value(3, 0);

    // Display using volume rendering
    SoVolumeRender volRender = new SoVolumeRender();

    // Assemble the volume rendering scene graph
    SoSeparator root = new SoSeparator();
    root.addChild(volData);
    root.addChild(transFunc);
    root.addChild(volRender);

    // Add the scene bounding box
    root.addChild(makeBBox(volData.extent.getValue(), new SbColor(1, 0, 0), 2));

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Bounding Box");
  }
}
