package inventor.sample.collisionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.collision.SoCollisionManager;
import com.openinventor.inventor.manips.SoTransformBoxManip;
import com.openinventor.inventor.manips.SoTransformManip;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.sensors.SoAlarmSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main (String [] argv) {
    Main example = new Main();
    example.demoMain("Collision Manager");
  }

  public Main() {}

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Scene graph initialisation ------------------------------------------------

    SoCone scene = new SoCone();

    SoTransformManip manip = new SoTransformBoxManip();
    manip.translation.setValue(4, 0, 0);

    SoMaterial material = new SoMaterial();
    material.diffuseColor.setValue(1, 0, 0);
    material.setOverride(true);

    final SoSwitch switchMaterial = new SoSwitch();
    switchMaterial.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    {
      switchMaterial.addChild(material);
    }

    SoSphere object = new SoSphere();

    SoSeparator root = new SoSeparator();
    {
      root.addChild(scene);
      root.addChild(manip);
      root.addChild(switchMaterial);
      root.addChild(object);
    }

    // Set up viewer -------------------------------------------------------------
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    // Set up the collision manager ----------------------------------------------
    SoPath objectPath = new SoPath(root);
    objectPath.regular.append(object);
    final SoCollisionManager collisionManager = new SoCollisionManager(objectPath, root, manip);


    final SoAlarmSensor flashSensor = new SoAlarmSensor(new Runnable() {
      @Override
      public void run() {
        switchMaterial.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    collisionManager.addCollisionListener(new SoCollisionManager.CollisionListener() {
      @Override
      public int collide(SoCollisionManager.CollidingPrimitive object,
                         SoCollisionManager.CollidingPrimitive scene)
      {
        switchMaterial.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        flashSensor.setTimeFromNow(new SbTime(0.15));
        flashSensor.schedule();
        return SoCollisionManager.CollisionListener.ABORT;
      }
    });


    // Setup the control dialog --------------------------------------------------
    final JCheckBox activationCheckBox = new JCheckBox("Active", true);
    activationCheckBox.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        collisionManager.activate(activationCheckBox.isSelected());
      }
    });

    final JCheckBox glueCheckBox = new JCheckBox("Gluing", true);
    glueCheckBox.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        collisionManager.setGluing(glueCheckBox.isSelected());
      }
    });

    JLabel glueLevelLabel = new JLabel("Gluing level");
    final JSlider glueLevelSlider = new JSlider(0, 10, 1);
    glueLevelSlider.addChangeListener(new ChangeListener() {
      @Override
      public void stateChanged(ChangeEvent e) {
        collisionManager.setGluingLevel(glueLevelSlider.getValue());
      }
    });

    final JCheckBox objectBBoxCheckBox = new JCheckBox("Object BBox only", false);
    objectBBoxCheckBox.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        collisionManager.setObjectBBoxOnly(objectBBoxCheckBox.isSelected());
      }
    });

    final JCheckBox sceneBBoxCheckBox = new JCheckBox("Scene BBox only", false);
    sceneBBoxCheckBox.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        collisionManager.setSceneBBoxOnly(sceneBBoxCheckBox.isSelected());
      }
    });


    JPanel uiPanel = new JPanel(new GridLayout(0, 1));
    uiPanel.add(activationCheckBox);
    uiPanel.add(new JLabel());
    uiPanel.add(glueCheckBox);
    uiPanel.add(glueLevelLabel);
    uiPanel.add(glueLevelSlider);
    uiPanel.add(new JLabel());
    uiPanel.add(objectBBoxCheckBox);
    uiPanel.add(sceneBBoxCheckBox);
    uiPanel.add(new JLabel());

    JPanel leftPanel = new JPanel();
    leftPanel.add(uiPanel);

    final Component component = myViewer.getComponent();
    component.setName("Object Moving");
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(leftPanel, BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

}
