package inventor.sample.depthBuffer;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoDepthBuffer;
import com.openinventor.inventor.nodes.SoFaceSet;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoMaterialBinding;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  SbVec3f[] vertices = new SbVec3f[]
  {
    new SbVec3f(1, 1, 0),
    new SbVec3f(1, -1, 0),
    new SbVec3f(-1, -1, 0),
    new SbVec3f(-1, 1, 0),
    new SbVec3f(1, 1, 0)
  };
  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoSeparator faceSep = new SoSeparator();
    {
      // Blue color material in front.
      SoMaterialBinding materialBindingFrontFlag = new SoMaterialBinding();
      materialBindingFrontFlag.face.setValue(SoMaterialBinding.Faces.FRONT);
      SoMaterial materialFrontFlag = new SoMaterial();
      materialFrontFlag.diffuseColor.setValue(0, 0, 1);

      // Green color material in back.
      SoMaterialBinding materialBindingBackFlag = new SoMaterialBinding();
      materialBindingBackFlag.face.setValue(SoMaterialBinding.Faces.BACK);
      SoMaterial materialBackFlag = new SoMaterial();
      materialBackFlag.diffuseColor.setValue(0, 1, 0);

      SoDepthBuffer faceDepth = new SoDepthBuffer();
      faceDepth.range.setValue(0, 1);

      SoFaceSet face = new SoFaceSet();
      face.numVertices.setValue(4);

      faceSep.addChild(materialBindingFrontFlag);
      faceSep.addChild(materialFrontFlag);
      faceSep.addChild(materialBindingBackFlag);
      faceSep.addChild(materialBackFlag);
      faceSep.addChild(faceDepth);
      faceSep.addChild(face);
    }

    SoSeparator lineSep = new SoSeparator();
    {
      SoMaterial lineMaterial = new SoMaterial();
      lineMaterial.diffuseColor.setValue(1, 0, 0);

      SoDepthBuffer lineDepth = new SoDepthBuffer();
      lineDepth.function.setValue(SoDepthBuffer.DepthWriteFunctions.ALWAYS);

      SoLineSet line = new SoLineSet();
      line.numVertices.setValue(5);

      lineSep.addChild(lineMaterial);
      lineSep.addChild(lineDepth);
      lineSep.addChild(line);
    }

    SoSeparator root = new SoSeparator();

    SoShapeHints shapeHint = new SoShapeHints();
    shapeHint.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    SoCoordinate3 coords = new SoCoordinate3();
    coords.point.setValues(0, vertices);

    root.addChild(coords);
    root.addChild(shapeHint);
    root.addChild(lineSep);
    root.addChild(faceSep);

    // attach and show viewer
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Depth buffer");
  }
}
