package inventor.sample.faceSetHole;

import java.awt.BorderLayout;

import javax.swing.UIManager;

import inventor.sample.faceSetHole.faceSetHole.OivSceneGraph;
import inventor.sample.faceSetHole.faceSetHole.SwingUI;
import util.Example;

/**
 * Shows the effect of a SoShapeHints.windingType
 * @author JM Godinaud
 */
public class Main extends Example
{

  private SwingUI ui;

  //Main method
  public static void main(String[] args) {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }

    Main example = new Main();
    example.demoMain("Face Set Hole");
  }

  @Override
  public void start() {
    ui = new SwingUI();
    ui.setSceneGraph(new OivSceneGraph());

    setLayout(new BorderLayout());
    add(ui.getPanel());
    add(ui.getMenuBar(), BorderLayout.NORTH);
  }

  @Override
  public void stop()
  {
    ui.destroy();
  }
}
