package inventor.sample.faceSetHole.faceSetHole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

import util.ViewerComponentsFactory;

/**
 * Shows the effect of a SoShapeHints.windingType
 * @author JM Godinaud
 */
public class SwingUI {
  private IRenderAreaExaminer m_sceneViewer;
  OivSceneGraph sg;
  JMenuBar jMenuBar = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuWindingType = new JMenu();
  JRadioButtonMenuItem jrb_positive = new JRadioButtonMenuItem();
  JRadioButtonMenuItem jrb_no_winding = new JRadioButtonMenuItem();
  JRadioButtonMenuItem jrb_non_zero = new JRadioButtonMenuItem();
  JRadioButtonMenuItem jrb_abs_geq = new JRadioButtonMenuItem();
  JRadioButtonMenuItem jrb_odd = new JRadioButtonMenuItem();
  JRadioButtonMenuItem jrb_negative = new JRadioButtonMenuItem();
  JPanel jOivViewerPanel = new JPanel();
  BorderLayout borderLayout = new BorderLayout();

  //Construct the frame
  public SwingUI() {
    //enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception  {
    m_sceneViewer = ViewerComponentsFactory.createRenderAreaExaminer();
    m_sceneViewer.setNavigationMode(NavigationMode.PLANE);
    
    JPopupMenu.setDefaultLightWeightPopupEnabled(false);

    jMenuFile.setText("File");
    jMenuFileExit.setText("Exit");
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    jMenuWindingType.setText("windingType");
    jrb_positive.setText("POSITIVE");
    jrb_positive.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_positive_actionPerformed(e);
      }
    });
    jrb_no_winding.setText("NO_WINDING");
    jrb_no_winding.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_no_winding_actionPerformed(e);
      }
    });
    jrb_non_zero.setText("NON_ZERO");
    jrb_non_zero.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_non_zero_actionPerformed(e);
      }
    });
    jrb_abs_geq.setText("ABS_GEQ_TWO");
    jrb_abs_geq.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_abs_geq_actionPerformed(e);
      }
    });
    jrb_odd.setText("ODD");
    jrb_odd.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_odd_actionPerformed(e);
      }
    });
    jrb_negative.setText("NEGATIVE");
    jrb_negative.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jrb_negative_actionPerformed(e);
      }
    });
    jOivViewerPanel.setLayout(borderLayout);
    jMenuFile.add(jMenuFileExit);
    jMenuBar.add(jMenuFile);
    jMenuBar.add(jMenuWindingType);
    jMenuWindingType.add(jrb_odd);
    jMenuWindingType.add(jrb_non_zero);
    jMenuWindingType.add(jrb_positive);
    jMenuWindingType.add(jrb_negative);
    jMenuWindingType.add(jrb_no_winding);
    jMenuWindingType.add(jrb_abs_geq);

    ButtonGroup windingGroup = new ButtonGroup();
    windingGroup.add(jrb_abs_geq);
    windingGroup.add(jrb_positive);
    windingGroup.add(jrb_negative);
    windingGroup.add(jrb_no_winding);
    windingGroup.add(jrb_odd);
    windingGroup.add(jrb_non_zero);

    final Component canvas = m_sceneViewer.getComponent();
    canvas.setPreferredSize(new java.awt.Dimension(600, 500));
    jOivViewerPanel.add(canvas);
  }
  
  public void destroy()
  {
    m_sceneViewer.dispose();
  }
  
  public void setSceneGraph(OivSceneGraph sg)
  {
    this.sg = sg;
    m_sceneViewer.setSceneGraph(sg.getSceneGraph());
    m_sceneViewer.viewAll(new SbViewportRegion(m_sceneViewer.getComponent().getSize()));
  }

  public JMenuBar getMenuBar() {
    return jMenuBar;
  }

  public JPanel getPanel() {
    return jOivViewerPanel;
  }

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  void jrb_odd_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.ODD_TYPE.getValue());
  }

  void jrb_non_zero_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.NON_ZERO_TYPE.getValue());
  }

  void jrb_positive_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.POSITIVE_TYPE.getValue());
  }

  void jrb_negative_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.NEGATIVE_TYPE.getValue());
  }

  void jrb_no_winding_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.NO_WINDING_TYPE.getValue());
  }

  void jrb_abs_geq_actionPerformed(ActionEvent e) {
    sg.setWindingType(SoShapeHints.WindingTypes.ABS_GEQ_TWO_TYPE.getValue());
  }

}
