package inventor.viewercomponents.awt.glcanvas.renderarea;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderArea;

import util.Example;

public class Main extends Example
{
  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private RenderArea renderArea;

  @Override
  public void start()
  {
    SoPerspectiveCamera camera = new SoPerspectiveCamera();
    SoSeparator rootSceneGraph = new SoSeparator();
    {
      rootSceneGraph.addChild(camera);
      rootSceneGraph.addChild(new SoDirectionalLight());
      rootSceneGraph.addChild(new SoCone());
    }

    camera.viewAll(rootSceneGraph, new SbViewportRegion(WIDTH, HEIGHT));

    renderArea = new RenderArea();
    renderArea.setSceneGraph(rootSceneGraph);

    renderArea.setPreferredSize(new java.awt.Dimension(WIDTH, HEIGHT));
    setLayout(new BorderLayout());
    add(renderArea);
  }

  @Override
  public void stop()
  {
    renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Open Inventor SoCone, using RenderArea");
  }

}
