package inventor.viewercomponents.awt.newt.renderarea;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.newt.renderareas.RenderArea;

import util.Example;

public class Main extends Example
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  private RenderArea m_renderArea;

  @Override
  public void start()
  {
    SoPerspectiveCamera camera = new SoPerspectiveCamera();
    SoSeparator rootSceneGraph = new SoSeparator();
    {
      rootSceneGraph.addChild(camera);
      rootSceneGraph.addChild(new SoDirectionalLight());
      rootSceneGraph.addChild(new SoCone());
    }

    camera.viewAll(rootSceneGraph, new SbViewportRegion(WIDTH, HEIGHT));

    m_renderArea = new RenderArea();
    m_renderArea.setSceneGraph(rootSceneGraph);

    m_renderArea.setPreferredSize(new java.awt.Dimension(WIDTH, HEIGHT));
    setLayout(new BorderLayout());
    add(m_renderArea);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Open Inventor SoCone, using NEWT RenderArea");
  }

}
