package inventor.viewercomponents.swt.glcanvas.renderareaorbiter;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.actions.SoHaloHighlightRenderAction;
import com.openinventor.inventor.misc.callbacks.SoSelectionClassCB;
import com.openinventor.inventor.nodes.SoFile;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderAreaOrbiter;

public class Main
{

  public static void main(String[] args)
  {
    Display display = new Display();
    Shell shell = new Shell(display);
    shell.setSize(1600, 900);
    shell.setText("RenderAreaOrbiter");
    shell.setLayout(new FillLayout(SWT.HORIZONTAL));

    RenderAreaOrbiter renderArea = new RenderAreaOrbiter(shell, SWT.NONE);

    // Scene graph
    SoSelection root = new SoSelection(); // We use here a SoSelection in order
                                          // to be able to "pick" the different
                                          // elements of the scene.

    SoFile modelFile = new SoFile();
    modelFile.name.set("$OIVJHOME/data/models/chair.iv");
    root.addChild(modelFile);

    renderArea.setSceneGraph(root);

    renderArea.setGLRenderAction(new SoHaloHighlightRenderAction());
    renderArea.setAntialiasingMode(AntialiasingModes.AUTO);
    renderArea.setAntialiasingQuality(1);

    // Add a callback on selection to redraw the scene and show
    // the highlight directly after picking a shape.
    root.addChangeCallback(new SoSelectionClassCB()
    {
      @Override
      public void invoke(SoSelection s)
      {
        renderArea.scheduleRedraw();
      }
    });

    renderArea.viewAll(new SbViewportRegion());

    shell.open();
    while ( !shell.isDisposed() )
    {
      if ( !display.readAndDispatch() )
        display.sleep();
    }
    display.dispose();
  }
}
