package medical.input.medicalDicomReader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoComplexity;
import com.openinventor.inventor.nodes.SoInteractiveComplexity;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.medical.helpers.MedicalHelper;
import com.openinventor.medical.nodes.Gnomon;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  public static final String EXAMPLE_NAME = "Medical Dicom Reader";
  public static final String DICOM_DATA = "/medical/data/dicomSample/listOfDicomFiles.dcm";
  public static final String COLORMAP = "/medical/data/resources/volrenGlow.am";
  public static final String ANNOTATION = "/medical/data/dicomSample/CVH001.dcm";

  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());
  private SoSeparator _root;
  private static String _dicom;
  private static String _colormap;
  private static String _annotation;
  private IRenderAreaExaminer _renderArea;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    printHelp();

    // Load example resources
    try
    {
      _dicom = (new File(Main.class.getResource(DICOM_DATA).toURI())).toString();
      _colormap = (new File(Main.class.getResource(COLORMAP).toURI()).toString());
      _annotation = (new File(Main.class.getResource(ANNOTATION).toURI()).toString());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    buildSceneGraph();

    _renderArea = ViewerComponentsFactory.createRenderAreaExaminer();
    _renderArea.setSceneGraph(_root);
    MedicalHelper.orientView(MedicalHelper.Axis.CORONAL,
        _renderArea.getSceneInteractor().getCameraInteractor().getCamera(), null);
    _renderArea.viewAll(new SbViewportRegion());

    final Component canvas = _renderArea.getComponent();
    canvas.setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(canvas);
  }

  @Override
  public void stop()
  {
    _renderArea.dispose();
  }

  /**
   * Build the scene graph to be displayed.
   */
  private void buildSceneGraph()
  {
    _root = new SoSeparator();

    // Add specular to change rendering quality.
    SoMaterial volumeMaterial = new SoMaterial();
    volumeMaterial.specularColor.setValue(0.26f, 0.26f, 0.26f);
    _root.addChild(volumeMaterial);

    // Node to hold the volume data
    SoVolumeData volData = new SoVolumeData();
    volData.ldmResourceParameters.getValue().tileDimension.setValue(128, 128, 128);
    // Request LDM to render using tiles at specified resolution level (Here
    // resolution 0 == full res).
    volData.ldmResourceParameters.getValue().fixedResolution.setValue(true);
    volData.ldmResourceParameters.getValue().resolution.setValue(0);
    volData.texturePrecision.setValue((short) 16); // Store actual values on
                                                   // GPU.
    volData.fileName.setValue(_dicom);
    _root.addChild(volData);

    // Load the colorMap
    SoTransferFunction pVRTransFunc = new SoTransferFunction();
    pVRTransFunc.loadColormap(_colormap);
    _root.addChild(pVRTransFunc);

    // remap data range to full range of data
    SoDataRange VRRange = new SoDataRange();
    VRRange.min.setValue(176);
    VRRange.max.setValue(476);
    _root.addChild(VRRange);

    // Change complexity when the dataset move.
    SoInteractiveComplexity intercatComplexity = new SoInteractiveComplexity();
    // Decrease the number of samples
    intercatComplexity.fieldSettings.set1Value(0, "SoComplexity value 0.3 0.9");
    intercatComplexity.fieldSettings.set1Value(1, "SoVolumeRenderingQuality preIntegrated FALSE TRUE");
    // Decrease interpolation quality.
    intercatComplexity.fieldSettings.set1Value(2, "SoVolumeRender interpolation LINEAR CUBIC");
    // Dont wait before returning to full quality rendering.
    intercatComplexity.refinementDelay.setValue(0);
    _root.addChild(intercatComplexity);
    _root.addChild(new SoComplexity());

    // Property node which allows SoVolumeRender to draw High Quality volumes.
    SoVolumeRenderingQuality pVRVolQuality = new SoVolumeRenderingQuality();
    // Remove tile boundary artifacts while moving.
    pVRVolQuality.interpolateOnMove.setValue(true);
    // Optional: Enable screen space lighting
    pVRVolQuality.deferredLighting.setValue(true);
    // Higher quality rendering
    pVRVolQuality.preIntegrated.setValue(true);
    pVRVolQuality.ambientOcclusion.setValue(true);
    _root.addChild(pVRVolQuality);

    // Node in charge of drawing the volume
    SoVolumeRender pVolRender = new SoVolumeRender();
    // Let Inventor compute best number of slices
    pVolRender.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.AUTOMATIC);
    // Optional: Use lower screen resolution while moving.
    pVolRender.lowScreenResolutionScale.setValue(2);
    pVolRender.lowResMode.setValue(SoVolumeRender.LowResModes.DECREASE_SCREEN_RESOLUTION);
    // Internal optimization.
    pVolRender.subdivideTile.setValue(true);
    // Remove "slicing" artifacts
    pVolRender.interpolation.setValue(SoVolumeRender.Interpolations.CUBIC);
    // Remove "slicing" artifacts
    pVolRender.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.BOUNDARY_ALIGNED);
    _root.addChild(pVolRender);

    // Scene orientation
    _root.addChild(new Gnomon());

    // Add Open Inventor logo at the left-bottom corner
    SoNode logoBackground = null;
    try
    {
      logoBackground = MedicalHelper.getExampleLogoNode();
    }
    catch (FileNotFoundException e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load logo", e);
    }
    _root.addChild(logoBackground);

    // DICOM annotation
    _root.addChild(MedicalHelper.exampleDicomAnnotation(_annotation));
  }
}
