package medical.rendering.techniques.simpleshader;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.medical.helpers.MedicalHelper;

import util.Example;

public class Main extends Example
{
  public static final String SHADER = "/medical/rendering/techniques/simpleshader/simpleShader.glsl";
  public static final String EXAMPLE_NAME = "Simple Shader";
  public static final String EXAMPLE_DESCRITPION = "This example shows how to use a shader";
  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());

  private SimpleShaderPanel examplePanel;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
    System.out.println(EXAMPLE_DESCRITPION);
    System.out.println("Left-click + drag the mouse to rotate");
    System.out.println("Scroll mouse wheel to zoom in/out");
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    printHelp();

    // Load example resources
    File shaderFile;
    try
    {
      shaderFile = new File(Main.class.getResource(SHADER).toURI());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    examplePanel = new SimpleShaderPanel(shaderFile.toString());
    examplePanel.setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(examplePanel);
  }

  @Override
  public void stop()
  {
    examplePanel.destroy();
  }
}
