// Simple fragment shader that implements a very simple Volume rendering
// and invert colors

//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId voldata;
uniform int transfer;

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
#if 1
  // get the data value at this position
  VVIZ_DATATYPE sf = VVizGetData(voldata,voxelInfoFront.texCoord);
  // get the color for this value through the transfer function
  vec4 res = VVizTransferFunction(sf, transfer);
#else
  // VolumeViz basic behavior
  vec4 res = VVizComputeVolumeRendering(voxelInfoFront.value, mask);
#endif

  // invert color  
  res.xyz = vec3(1.) - res.xyz;
  
  return res;
}
