package medical.segmentation.simpleclippinggroup;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.openinventor.medical.helpers.MedicalHelper;

import util.Example;

public class Main extends Example
{
  public static final String DATA = "/medical/data/files/3DHEAD.ldm";
  public static final String COLORMAP = "/medical/data/resources/volrenGlow.am";
  public static final String EXAMPLE_NAME = "Simple Clipping Group";
  public static final String EXAMPLE_DESCRITPION = "This example shows how to use the node SoVolumeClippingGroup";
  private final static Logger LOGGER = Logger.getLogger(Main.class.getName());

  private SimpleClippingGroupPanel m_examplePanel;

  public static void printHelp()
  {
    System.out.println("Launching example: " + EXAMPLE_NAME);
    System.out.println(EXAMPLE_DESCRITPION);
    System.out.println("Left-click + drag the mouse to rotate");
    System.out.println("Scroll mouse wheel to zoom in/out");
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain(EXAMPLE_NAME);
  }

  @Override
  public void start()
  {
    printHelp();

    // Load example resources
    File dataFile, colormapFile;
    try
    {
      dataFile = new File(Main.class.getResource(DATA).toURI());
      colormapFile = new File(Main.class.getResource(COLORMAP).toURI());
    }
    catch (Exception e)
    {
      LOGGER.log(Level.SEVERE, "Failed to load resources", e);
      return;
    }

    m_examplePanel = new SimpleClippingGroupPanel(dataFile.toString(), colormapFile.toString());

    setPreferredSize(new java.awt.Dimension(MedicalHelper.WINDOW_WIDTH, MedicalHelper.WINDOW_HEIGHT));
    setLayout(new BorderLayout());
    add(m_examplePanel);
  }

  @Override
  public void stop()
  {
    m_examplePanel.destroy();
  }
}
