/*
* Main.java
*/
package meshviz.graph.advanced.Grapher;

import java.awt.BorderLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.engines.SoCalculator;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.fields.SoMFFloat;
import com.openinventor.inventor.gui.view.PoSceneView;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.* ;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor.CameraMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

/*
* Class:   Main
*/
public class Main extends Grapher_Abstract
{
  float xmin,xmax,ymin,ymax;
  PoDomain domain;
  PoDomain domain_axis;
  SbVec2f[] points;
  SoOrthographicCamera graphCamera;
  SoOrthographicCamera axisCamera;
  PoSceneView axisView;
  PoSceneView graphView;
  static IRenderAreaExaminer viewer;
  PoLinearAxis xAxis = null;
  PoLinearAxis yAxis = null;
  String formula1 = "cos(4*a)*cos(a)";
  String formula2 = "cos(4*a)*sin(a)";
  ListenMove mouseMoveListener;
  Vector<URL> listURL;
  int curURL = -1;
  /*
   * Constructor: Main
   * Return: instance of Main
   */
  public Main()
  {
    super();

    listURL = new Vector<URL>();
    listURL.add(getClass().getResource("./about.htm"));
    curURL++;

    get_EditorPane1().addHyperlinkListener(new Hyperactive());

    mouseMoveListener = new ListenMove();
  } /* End of Constructor: Main */

  /*
   * Method: generalHandleException
   * Params: java.lang.Throwable exception
   * Return: void
   */
  @Override
  protected void generalHandleException(java.lang.Throwable exc)
  {
    exc.printStackTrace(System.err);
  } /* End of Method: generalHandleException */

  /*
   * Method: main
   * Params: java.lang.String[]
   * Return: void
   */
  public static void main(java.lang.String[] arg)
  {
    viewer = ViewerComponentsFactory.createRenderAreaExaminer();
    viewer.getSceneInteractor().setNavigationMode(NavigationMode.PLANE);

    Main example = new Main();
    JFrame frame = example.get_Frame();
    example.get_Panel4().add("Center", viewer.getComponent());
    example.initScene();
    example.initData(0, 6.28f, 250);
    example.updateView();
    frame.setVisible(true);
  } /* End of Method: main */

  @Override
  public void start() {
    viewer = ViewerComponentsFactory.createRenderAreaExaminer();
    viewer.getSceneInteractor().setNavigationMode(NavigationMode.PLANE);

    get_Panel4().add("Center",viewer.getComponent());
    setLayout(new BorderLayout());
    add(get_TabbedPane());
    initScene();
    initData(0,6.28f,250);
    updateView();
    setVisible(true);
  }

  @Override
  public void stop()
  {
    viewer.dispose();
  }

  public void initScene() {

    domain = new PoDomain();
    domain_axis = new PoDomain();

    // Build the axis view
    axisView = new PoSceneView() ;
    axisView.viewportOrigin.setValue(0.0f, 0.0f) ;
    axisView.viewportSize.setValue(1.0f, 1.0f) ;
    axisCamera = new SoOrthographicCamera();
    axisCamera.viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);
    axisView.setPart("cameraKit.camera", axisCamera) ;

    // Build the curve view
    graphView = new PoSceneView() ;
    graphView.viewportOrigin.setValue(0.1f, 0.1f) ;
    graphView.viewportSize.setValue(0.8f, 0.8f) ;
    viewer.getSceneInteractor().setCameraMode(CameraMode.ORTHOGRAPHIC);
    graphCamera = (SoOrthographicCamera) viewer.getSceneInteractor().getCamera();
    graphCamera.viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);
    graphView.setPart("cameraKit.camera", graphCamera) ;

    // Build the entire graph
    SoSeparator root = new SoSeparator();

    SoDirectionalLight dirLight = new SoDirectionalLight();
    dirLight.direction.setValue( 0.2F, -0.2F, -1.F) ;
    root.addChild(dirLight) ;
    root.addChild(axisView) ;
    root.addChild(graphView) ;
    viewer.getSceneInteractor().enableHeadlight(false) ;
    viewer.setSceneGraph(root);

    final SoEventCallback eventCallback = new SoEventCallback();
    viewer.getSceneInteractor().insertChild(eventCallback, 0);

    eventCallback.addEventCallback(SoMouseButtonEvent.class, new SoEventCallbackCB()
    {
      @Override
      public void invoke(SoEventCallback node)
      {
        if ( viewer.getSceneInteractor().getInteractionMode() == InteractionMode.SELECTION )
          return;

        SoEvent evt = node.getEvent();

        if ( evt != null )
        {
          if ( SoMouseButtonEvent.isButtonPressEvent(evt, SoMouseButtonEvent.Buttons.BUTTON1)
              || SoMouseButtonEvent.isButtonPressEvent(evt, SoMouseButtonEvent.Buttons.BUTTON2) )
          {
            viewer.getGLRenderAction().setNumPasses(1);
            eventCallback.addEventCallback(SoLocation2Event.class, mouseMoveListener);
          }
          else if ( SoMouseButtonEvent.isButtonReleaseEvent(evt, SoMouseButtonEvent.Buttons.BUTTON1)
              || SoMouseButtonEvent.isButtonReleaseEvent(evt, SoMouseButtonEvent.Buttons.BUTTON2) )
          {
            eventCallback.removeEventCallback(SoLocation2Event.class, mouseMoveListener, null);
            viewer.getGLRenderAction().setNumPasses(3);
            viewer.scheduleRedraw();
          }
        }
      }
    });
    viewer.getComponent().addHierarchyListener(new HierarchyListener()
    {

      @Override
      public void hierarchyChanged(HierarchyEvent e)
      {
        if ( (e.getChangeFlags() & HierarchyEvent.SHOWING_CHANGED) != 0 && isShowing())
          viewer.getGLRenderAction().setNumPasses(3);
      }
    });
  }

  public void initData(float minVal, float maxVal, int numVal) {
    SoCalculator calc = new SoCalculator();
    calc.expression.set1Value(0,"oa="+formula1);
    SoMFFloat outputVal1 = (SoMFFloat)SoDB.createGlobalField("outputVal1",SoMFFloat.class);
    outputVal1.connectFrom(calc.oa);
    SoMFFloat outputVal2 = null;
    if (formula2.length() != 0) {
      outputVal2 = (SoMFFloat)SoDB.createGlobalField("outputVal2",SoMFFloat.class);
      calc.expression.set1Value(1,"ob="+formula2);
      outputVal2.connectFrom(calc.ob);
    }
    points = new SbVec2f[numVal];
    int i;
    float x,y;
    float step = (maxVal-minVal)/(numVal-1);
    float a = minVal;
    xmin = Float.MAX_VALUE;
    xmax = Float.MIN_VALUE;
    ymin = Float.MAX_VALUE;
    ymax = Float.MIN_VALUE;
    for(i=0; i<numVal; i++, a += step) {
      calc.a.setValue(a);
      if (formula2.length() != 0) {
        calc.b.setValue(a);
        x = outputVal1.getValueAt(0);
        y = outputVal2.getValueAt(0);
      }
      else {
        x = a;
        y = outputVal1.getValueAt(0);
      }
      xmin = Math.min(xmin,x);
      xmax = Math.max(xmax,x);
      ymin = Math.min(ymin,y);
      ymax = Math.max(ymax,y);
      points[i] = new SbVec2f(x,y);
    }
    //    domain = new PoDomain();
    domain.min.setValue(new SbVec3f(xmin,ymin,0));
    domain.max.setValue(new SbVec3f(xmax,ymax,0));
    domain.transformType.setValue(PoDomain.TransformTypes.TRANSFORM_01);
    domain_axis.min.setValue(new SbVec3f(xmin,ymin,0));
    domain_axis.max.setValue(new SbVec3f(xmax,ymax,0));
    domain_axis.transformType.setValue(PoDomain.TransformTypes.TRANSFORM_01);
  }

  public void updateView() {
    axisView.setPart("scene", buildAxis()) ;
    graphView.setPart("scene", buildScene()) ;
  }

  public SoAnnotation buildScene() {

    SoAnnotation root = new SoAnnotation();

    PoCurve curve = new PoCurve();
    curve.point.setValues(0, points);
    curve.set("curvePointApp.material", "diffuseColor [1 0 0]");
    curve.set("curvePointApp.drawStyle", "lineWidth 2");

    root.addChild(domain);
    root.addChild(curve);

    graphCamera.position.setValue(.5f,.5f,1);
    graphCamera.pointAt(new SbVec3f(.5f,.5f,0));
    graphCamera.height.setValue(1);

    return root;
  }

  public SoAnnotation buildAxis() {

    SoAnnotation root = new SoAnnotation();

    SoAnnoText3Property textProp = new SoAnnoText3Property();
    textProp.renderPrintType.setValue(SoAnnoText3Property.RenderPrintTypes.RENDER2D_PRINT_RASTER);

    SoTransform trans = new SoTransform();
    trans.scaleFactor.setValue(.8f,.8f,1);
    trans.translation.setValue(.1f,.1f,0);

    xAxis = new PoLinearAxis();
    xAxis.start.setValue(new SbVec3f(xmin,ymin,0));
    xAxis.end.setValue(xmax);
    xAxis.type.setValue(PoCartesianAxis.Types.XY);
    xAxis.arrowVisibility.setValue(PoAxis.Visibilities.VISIBILITY_OFF);
    xAxis.gridVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON);
    xAxis.gridLengthGradOtherSide.setValue(ymax-ymin);
    xAxis.tickSubDef.setValue(PoAxis.TickSubDefs.NUM_SUB_TICK);
    xAxis.tickNumOrPeriod.setValue((short)8);
    xAxis.set("appearance.material", "diffuseColor 1 1 1") ;
    xAxis.set("subGradGridApp.drawStyle","style INVISIBLE");
    xAxis.set("mainGradGridApp.material","diffuseColor .3 .3 .3");

    yAxis = new PoLinearAxis();
    yAxis.start.setValue(new SbVec3f(xmin,ymin,0));
    yAxis.end.setValue(ymax);
    yAxis.type.setValue(PoCartesianAxis.Types.YX);
    yAxis.arrowVisibility.setValue(PoAxis.Visibilities.VISIBILITY_OFF);
    yAxis.gridVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON);
    yAxis.gridLengthGradOtherSide.setValue(xmax-xmin);
    yAxis.tickSubDef.setValue(PoAxis.TickSubDefs.NUM_SUB_TICK);
    yAxis.tickNumOrPeriod.setValue((short)8);
    yAxis.set("appearance.material", "diffuseColor 1 1 1") ;
    yAxis.set("subGradGridApp.drawStyle","style INVISIBLE");
    yAxis.set("mainGradGridApp.material","diffuseColor .3 .3 .3");

    SoTransformSeparator titleSep = new SoTransformSeparator();
    SoTranslation transTitle = new SoTranslation();
    transTitle.translation.setValue(1,.95f,0);
    SoFont fontTitle = new SoFont();
    fontTitle.size.setValue(18);
    SoText2 title = new SoText2();
    title.justification.setValue(SoText2.Justifications.RIGHT);
    if ( formula2.length() != 0 )
    {
      title.string.set1Value(0, "x=" + formula1);
      title.string.set1Value(1, "y=" + formula2);
    }
    else
    {
      title.string.set1Value(0, "y=" + formula1);
    }
    titleSep.addChild(transTitle);
    titleSep.addChild(fontTitle);
    titleSep.addChild(title);

    root.addChild(textProp);
    root.addChild(titleSep);
    root.addChild(trans);
    root.addChild(domain_axis);
    root.addChild(xAxis);
    root.addChild(yAxis);

    axisCamera.position.setValue(.5f,.5f,1);
    axisCamera.pointAt(new SbVec3f(.5f,.5f,0));
    axisCamera.height.setValue(1);

    return root;
  }

  class ListenMove extends SoEventCallbackCB
  {

    @Override
    public void invoke(SoEventCallback node)
    {
      if (formula1 == null) return;
      float [] pos = graphCamera.position.getValue().getValue();
      float height = graphCamera.height.getValue();
      float newXmin = (xmax-xmin)*(pos[0]-height/2.f)+xmin;
      float newXmax = (xmax-xmin)*(pos[0]+height/2.f)+xmin;
      float newYmin = (ymax-ymin)*(pos[1]-height/2.f)+ymin;
      float newYmax = (ymax-ymin)*(pos[1]+height/2.f)+ymin;
      domain_axis.min.setValue(new SbVec3f(newXmin,newYmin,0));
      domain_axis.max.setValue(new SbVec3f(newXmax,newYmax,0));
      xAxis.start.setValue(new SbVec3f(newXmin,newYmin,0));
      xAxis.end.setValue(newXmax);
      xAxis.gridLengthGradOtherSide.setValue(newYmax-newYmin);
      yAxis.start.setValue(new SbVec3f(newXmin,newYmin,0));
      yAxis.end.setValue(newYmax);
      yAxis.gridLengthGradOtherSide.setValue(newXmax-newXmin);
    }

  }

  /*
   * Method: Button_actionPerformed
   * Note  : Invoked when an action occurs.
   * Params: java.awt.event.ActionEvent
   * Return: void
   */
  @Override
  protected void Button_actionPerformed(java.awt.event.ActionEvent evt)
  {
    formula1 = get_TextField().getText();
    formula2 = get_TextField1().getText();
    float vmin = Float.valueOf(get_TextField2().getText()).floatValue();
    float vmax = Float.valueOf(get_TextField3().getText()).floatValue();
    int numPoints = Integer.valueOf(get_TextField4().getText()).intValue();
    initData(vmin,vmax,numPoints);
    updateView();
  } /* End of Method: Button_actionPerformed */

  /*
   * Method: Frame_windowClosed
   * Note  : Invoked when a window has been closed as the result of
   *         calling dispose on the window.
   * Params: java.awt.event.WindowEvent
   * Return: void
   */
  @Override
  protected void Frame_windowClosed(java.awt.event.WindowEvent evt)
  {
    stop();
    System.exit(0);
  } /* End of Method: Frame_windowClosed */


  class Hyperactive implements HyperlinkListener {
    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
      if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        try {
          if (curURL < listURL.size()-1) {
            listURL.add(listURL.elementAt(curURL));
            curURL++;
          }
          listURL.add(e.getURL());
          curURL++;
          get_EditorPane1().setPage(e.getURL());
        } catch (Throwable t) {t.printStackTrace();}
      }
    }
  }

  /*
   * Method: Button3_actionPerformed
   * Note  : Invoked when an action occurs.
   * Params: java.awt.event.ActionEvent
   * Return: void
   */
  @Override
  protected void Button3_actionPerformed(java.awt.event.ActionEvent evt)
  {
    if (curURL > 0) {
      curURL--;
      try {
        get_EditorPane1().setPage((listURL.elementAt(curURL)));
      } catch (Exception e) {}
    }

  } /* End of Method: Button3_actionPerformed */

  /*
   * Method: Button4_actionPerformed
   * Note  : Invoked when an action occurs.
   * Params: java.awt.event.ActionEvent
   * Return: void
   */
  @Override
  protected void Button4_actionPerformed(java.awt.event.ActionEvent evt)
  {
    if (curURL < listURL.size()-1) {
      curURL++;
      try {
        get_EditorPane1().setPage((listURL.elementAt(curURL)));
      } catch (Exception e) {}
    }
  } /* End of Method: Button4_actionPerformed */
} /* End of Class: Main */

/*
 * Class:   abstract Grapher_Abstract
 */
abstract class Grapher_Abstract extends Example
{
  /* Variables declaration - Frame */
  private javax.swing.JFrame _Frame;
  private javax.swing.JTabbedPane _TabbedPane;
  private javax.swing.JPanel _Panel;
  private javax.swing.JPanel _Panel3;
  private javax.swing.border.BevelBorder _BevelBorder;
  private javax.swing.JLabel _Label;
  private javax.swing.JLabel _Label1;
  private javax.swing.JTextField _TextField;
  private javax.swing.JTextField _TextField1;
  private javax.swing.JLabel _Label2;
  private javax.swing.JLabel _Label3;
  private javax.swing.JTextField _TextField2;
  private javax.swing.JTextField _TextField3;
  private javax.swing.JLabel _Label4;
  private javax.swing.JTextField _TextField4;
  private javax.swing.JButton _Button;
  private javax.swing.JPanel _Panel4;
  private javax.swing.border.BevelBorder _BevelBorder1;
  private javax.swing.JPanel _Panel1;
  private javax.swing.JEditorPane _EditorPane;
  private javax.swing.JScrollPane _EditorPane_Pane;
  private javax.swing.JPanel _Panel2;
  private javax.swing.JEditorPane _EditorPane1;
  private javax.swing.JScrollPane _EditorPane1_Pane;
  private javax.swing.JPanel _Panel6;
  private javax.swing.JButton _Button3;
  private javax.swing.JButton _Button4;
  private javax.swing.border.EtchedBorder _EtchedBorder;
  /* End of variables declaration - Frame */

    /*
     * Method: Constructor
     * Params: None
     * Return: Instance of Grapher_Abstract
     */
  protected Grapher_Abstract()
  {
    super();
  } /* End of Method: Constructor */

  /*
     * Method: get_Frame
     * Params: None
     * Return: javax.swing.JFrame
     */
  protected javax.swing.JFrame get_Frame()
  {
    if (_Frame == null)
      {
        _Frame = Frame_CreateInstance();
        javax.swing.JFrame self = _Frame;
        self.setName("Frame");
        self.setBounds(72,46,700,600);
        self.setTitle("Open Inventor Java - Grapher demo");
        self.setResizable(true);
        self.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        /* Adds Child */
        self.getContentPane().add(get_TabbedPane(),java.awt.BorderLayout.CENTER);
        /* Adds Listener(s) */
        self.addWindowListener(new Frame_WindowAdapter());
      } /* End if */
    return _Frame;
  } /* End of Method: get_Frame */


  /*
     * Method: Frame_CreateInstance
     * Params: None
     * Return: javax.swing.JFrame
     */
  protected javax.swing.JFrame Frame_CreateInstance()
  {
    return new javax.swing.JFrame();
  } /* End of Method: Frame_CreateInstance */

  /*
     * Method: Frame_windowClosed
     * Note  : Invoked when a window has been closed as the result of
     *         calling dispose on the window.
     * Params: java.awt.event.WindowEvent
     * Return: void
     */
  protected abstract void Frame_windowClosed(java.awt.event.WindowEvent evt);
  /* This abstract method is overloaded by the "Main.java" source code. */

    /*
     * Class:   Frame_WindowAdapter
     * Interface: WindowListener
     * Adapter: java.awt.event.Window
     */
  protected class Frame_WindowAdapter implements java.awt.event.WindowListener
  {
    /*
     * Interface: WindowListener
     * Method: windowOpened
     * Params: java.awt.event.WindowEvent
     * Return: void
     */
    @Override
    public void windowOpened(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowOpened */

    /*
         * Interface: WindowListener
         * Method: windowClosing
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowClosing(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowClosing */

    /*
         * Interface: WindowListener
         * Method: windowClosed
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowClosed(java.awt.event.WindowEvent evt)
    {
      Frame_windowClosed(evt);
    } /* End of Method: windowClosed */

    /*
         * Interface: WindowListener
         * Method: windowIconified
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowIconified(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowIconified */

    /*
         * Interface: WindowListener
         * Method: windowDeiconified
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowDeiconified(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowDeiconified */

    /*
         * Interface: WindowListener
         * Method: windowActivated
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowActivated(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowActivated */

    /*
         * Interface: WindowListener
         * Method: windowDeactivated
         * Params: java.awt.event.WindowEvent
         * Return: void
         */
    @Override
    public void windowDeactivated(java.awt.event.WindowEvent evt)
    { /* This empty method is required by WindowListener implementation */
    } /* End of Method: windowDeactivated */
  } /* End of Class: Frame_WindowAdapter */

  /*
     * Method: get_TabbedPane
     * Params: None
     * Return: javax.swing.JTabbedPane
     */
  protected javax.swing.JTabbedPane get_TabbedPane()
  {
    if (_TabbedPane == null)
      {
        _TabbedPane = TabbedPane_CreateInstance();
        javax.swing.JTabbedPane self = _TabbedPane;
        self.setName("TabbedPane");
        self.setOpaque(false);
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_EtchedBorder()));
        /* Adds Children */
        self.insertTab("Graph",null,get_Panel(),null,0);
        self.insertTab("Help",null,get_Panel1(),null,1);
        self.insertTab("About",null,get_Panel2(),null,2);
      } /* End if */
    return _TabbedPane;
  } /* End of Method: get_TabbedPane */

  /*
     * Method: TabbedPane_CreateInstance
     * Params: None
     * Return: javax.swing.JTabbedPane
     */
  protected javax.swing.JTabbedPane TabbedPane_CreateInstance()
  {
    return new javax.swing.JTabbedPane();
  } /* End of Method: TabbedPane_CreateInstance */

  /*
     * Method: get_Panel
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel()
  {
    if (_Panel == null)
      {
        _Panel = Panel_CreateInstance();
        javax.swing.JPanel self = _Panel;
        self.setName("Panel");
        /* set Layout */
        self.setLayout(new java.awt.BorderLayout(5,5));
        /* Adds Children */
        self.add(get_Panel3(),java.awt.BorderLayout.NORTH);
        self.add(get_Panel4(),java.awt.BorderLayout.CENTER);
      } /* End if */
    return _Panel;
  } /* End of Method: get_Panel */

  /*
     * Method: Panel_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel_CreateInstance */

  /*
     * Method: get_Panel3
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel3()
  {
    if (_Panel3 == null)
      {
        _Panel3 = Panel3_CreateInstance();
        javax.swing.JPanel self = _Panel3;
        self.setName("Panel3");
        self.setBounds(0,0,565,63);
        self.setPreferredSize(new java.awt.Dimension(565,63));
        self.setMinimumSize(new java.awt.Dimension(565,63));
        /* set Layout */
        java.awt.GridBagLayout gridBagLayout = new java.awt.GridBagLayout();
        self.setLayout(gridBagLayout);
        java.awt.GridBagConstraints constraints = new java.awt.GridBagConstraints();
        constraints.insets = new java.awt.Insets(1,1,1,1);
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_BevelBorder()));
        /* Adds Children */
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = java.awt.GridBagConstraints.WEST;
        constraints.fill = java.awt.GridBagConstraints.NONE;
        gridBagLayout.setConstraints(get_Label(), constraints);
        self.add(get_Label());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_Label1(), constraints);
        self.add(get_Label1());
        constraints.gridx = 1;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_TextField(), constraints);
        self.add(get_TextField());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_TextField1(), constraints);
        self.add(get_TextField1());
        constraints.gridx = 2;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_Label2(), constraints);
        self.add(get_Label2());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_Label3(), constraints);
        self.add(get_Label3());
        constraints.gridx = 3;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_TextField2(), constraints);
        self.add(get_TextField2());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_TextField3(), constraints);
        self.add(get_TextField3());
        constraints.gridx = 4;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_Label4(), constraints);
        self.add(get_Label4());
        constraints.gridx = 5;
        gridBagLayout.setConstraints(get_TextField4(), constraints);
        self.add(get_TextField4());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_Button(), constraints);
        self.add(get_Button());
        javax.swing.ButtonGroup buttonGroup = new javax.swing.ButtonGroup();
        buttonGroup.add(get_Button());
      } /* End if */
    return _Panel3;
  } /* End of Method: get_Panel3 */

  /*
     * Method: Panel3_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel3_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel3_CreateInstance */

  /*
     * Method: get_BevelBorder
     * Params: None
     * Return: javax.swing.border.BevelBorder
     */
  protected javax.swing.border.BevelBorder get_BevelBorder()
  {
    if (_BevelBorder == null)
      {
        _BevelBorder = new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED);
      } /* End if */
    return _BevelBorder;
  } /* End of Method: get_BevelBorder */

  /*
     * Method: get_Label
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel get_Label()
  {
    if (_Label == null)
      {
        _Label = Label_CreateInstance();
        javax.swing.JLabel self = _Label;
        self.setName("Label");
        self.setBounds(255,12,90,22);
        self.setPreferredSize(new java.awt.Dimension(90,22));
        self.setMinimumSize(new java.awt.Dimension(90,22));
        self.setText("y=f(a) or x=f(a)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      } /* End if */
    return _Label;
  } /* End of Method: get_Label */

  /*
     * Method: Label_CreateInstance
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel Label_CreateInstance()
  {
    return new javax.swing.JLabel();
  } /* End of Method: Label_CreateInstance */

  /*
     * Method: get_Label1
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel get_Label1()
  {
    if (_Label1 == null)
      {
        _Label1 = Label1_CreateInstance();
        javax.swing.JLabel self = _Label1;
        self.setName("Label1");
        self.setBounds(342,25,90,22);
        self.setPreferredSize(new java.awt.Dimension(90,22));
        self.setMinimumSize(new java.awt.Dimension(90,22));
        self.setText("y=f(a)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      } /* End if */
    return _Label1;
  } /* End of Method: get_Label1 */

  /*
     * Method: Label1_CreateInstance
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel Label1_CreateInstance()
  {
    return new javax.swing.JLabel();
  } /* End of Method: Label1_CreateInstance */

  /*
     * Method: get_TextField
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField get_TextField()
  {
    if (_TextField == null)
      {
        _TextField = TextField_CreateInstance();
        javax.swing.JTextField self = _TextField;
        self.setName("TextField");
        self.setBounds(401,32,200,22);
        self.setPreferredSize(new java.awt.Dimension(200,22));
        self.setMinimumSize(new java.awt.Dimension(200,22));
        self.setEditable(true);
        self.setText("cos(4*a)*cos(a)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      } /* End if */
    return _TextField;
  } /* End of Method: get_TextField */

  /*
     * Method: TextField_CreateInstance
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField TextField_CreateInstance()
  {
    return new javax.swing.JTextField();
  } /* End of Method: TextField_CreateInstance */

  /*
     * Method: get_TextField1
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField get_TextField1()
  {
    if (_TextField1 == null)
      {
        _TextField1 = TextField1_CreateInstance();
        javax.swing.JTextField self = _TextField1;
        self.setName("TextField1");
        self.setBounds(317,28,200,22);
        self.setPreferredSize(new java.awt.Dimension(200,22));
        self.setMinimumSize(new java.awt.Dimension(200,22));
        self.setEditable(true);
        self.setText("cos(4*a)*sin(a)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      } /* End if */
    return _TextField1;
  } /* End of Method: get_TextField1 */

  /*
     * Method: TextField1_CreateInstance
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField TextField1_CreateInstance()
  {
    return new javax.swing.JTextField();
  } /* End of Method: TextField1_CreateInstance */

  /*
     * Method: get_Label2
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel get_Label2()
  {
    if (_Label2 == null)
      {
        _Label2 = Label2_CreateInstance();
        javax.swing.JLabel self = _Label2;
        self.setName("Label2");
        self.setBounds(252,22,35,22);
        self.setPreferredSize(new java.awt.Dimension(35,22));
        self.setMinimumSize(new java.awt.Dimension(35,22));
        self.setText("a min");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      } /* End if */
    return _Label2;
  } /* End of Method: get_Label2 */

  /*
     * Method: Label2_CreateInstance
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel Label2_CreateInstance()
  {
    return new javax.swing.JLabel();
  } /* End of Method: Label2_CreateInstance */

  /*
     * Method: get_Label3
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel get_Label3()
  {
    if (_Label3 == null)
      {
        _Label3 = Label3_CreateInstance();
        javax.swing.JLabel self = _Label3;
        self.setName("Label3");
        self.setBounds(202,26,35,22);
        self.setPreferredSize(new java.awt.Dimension(35,22));
        self.setMinimumSize(new java.awt.Dimension(35,22));
        self.setText("a max");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      } /* End if */
    return _Label3;
  } /* End of Method: get_Label3 */

  /*
     * Method: Label3_CreateInstance
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel Label3_CreateInstance()
  {
    return new javax.swing.JLabel();
  } /* End of Method: Label3_CreateInstance */

  /*
     * Method: get_TextField2
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField get_TextField2()
  {
    if (_TextField2 == null)
      {
        _TextField2 = TextField2_CreateInstance();
        javax.swing.JTextField self = _TextField2;
        self.setName("TextField2");
        self.setBounds(198,8,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("0");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      } /* End if */
    return _TextField2;
  } /* End of Method: get_TextField2 */

  /*
     * Method: TextField2_CreateInstance
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField TextField2_CreateInstance()
  {
    return new javax.swing.JTextField();
  } /* End of Method: TextField2_CreateInstance */

  /*
     * Method: get_TextField3
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField get_TextField3()
  {
    if (_TextField3 == null)
      {
        _TextField3 = TextField3_CreateInstance();
        javax.swing.JTextField self = _TextField3;
        self.setName("TextField3");
        self.setBounds(165,5,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("6.28");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      } /* End if */
    return _TextField3;
  } /* End of Method: get_TextField3 */

  /*
     * Method: TextField3_CreateInstance
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField TextField3_CreateInstance()
  {
    return new javax.swing.JTextField();
  } /* End of Method: TextField3_CreateInstance */

  /*
     * Method: get_Label4
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel get_Label4()
  {
    if (_Label4 == null)
      {
        _Label4 = Label4_CreateInstance();
        javax.swing.JLabel self = _Label4;
        self.setName("Label4");
        self.setBounds(161,22,45,22);
        self.setPreferredSize(new java.awt.Dimension(45,22));
        self.setMinimumSize(new java.awt.Dimension(45,22));
        self.setText("#points");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      } /* End if */
    return _Label4;
  } /* End of Method: get_Label4 */

  /*
     * Method: Label4_CreateInstance
     * Params: None
     * Return: javax.swing.JLabel
     */
  protected javax.swing.JLabel Label4_CreateInstance()
  {
    return new javax.swing.JLabel();
  } /* End of Method: Label4_CreateInstance */

  /*
     * Method: get_TextField4
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField get_TextField4()
  {
    if (_TextField4 == null)
      {
        _TextField4 = TextField4_CreateInstance();
        javax.swing.JTextField self = _TextField4;
        self.setName("TextField4");
        self.setBounds(254,30,50,22);
        self.setPreferredSize(new java.awt.Dimension(50,22));
        self.setMinimumSize(new java.awt.Dimension(50,22));
        self.setEditable(true);
        self.setText("250");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      } /* End if */
    return _TextField4;
  } /* End of Method: get_TextField4 */

  /*
     * Method: TextField4_CreateInstance
     * Params: None
     * Return: javax.swing.JTextField
     */
  protected javax.swing.JTextField TextField4_CreateInstance()
  {
    return new javax.swing.JTextField();
  } /* End of Method: TextField4_CreateInstance */

  /*
     * Method: get_Button
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton get_Button()
  {
    if (_Button == null)
      {
        _Button = Button_CreateInstance();
        javax.swing.JButton self = _Button;
        self.setName("Button");
        self.setBounds(231,37,50,22);
        self.setPreferredSize(new java.awt.Dimension(50,22));
        self.setMinimumSize(new java.awt.Dimension(50,22));
        self.setText("Go");
        /* Adds Listener(s) */
        self.addActionListener(new Button_ActionAdapter());
      } /* End if */
    return _Button;
  } /* End of Method: get_Button */

  /*
     * Method: Button_CreateInstance
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton Button_CreateInstance()
  {
    return new javax.swing.JButton();
  } /* End of Method: Button_CreateInstance */

  /*
     * Method: Button_actionPerformed
     * Note  : Invoked when an action occurs.
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
  protected abstract void Button_actionPerformed(java.awt.event.ActionEvent evt);
  /* This abstract method is overloaded by the "Main.java" source code. */

    /*
     * Class:   Button_ActionAdapter
     * Interface: ActionListener
     * Adapter: java.awt.event.Action
     */
  protected class Button_ActionAdapter implements java.awt.event.ActionListener
  {
    /*
     * Interface: ActionListener
     * Method: actionPerformed
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button_actionPerformed(evt);
    } /* End of Method: actionPerformed */
  } /* End of Class: Button_ActionAdapter */

  /*
     * Method: get_Panel4
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel4()
  {
    if (_Panel4 == null)
      {
        _Panel4 = Panel4_CreateInstance();
        javax.swing.JPanel self = _Panel4;
        self.setName("Panel4");
        self.setBounds(0,55,533,312);
        self.setPreferredSize(new java.awt.Dimension(533,312));
        self.setMinimumSize(new java.awt.Dimension(533,312));
        /* set Layout */
        self.setLayout(new java.awt.BorderLayout(5,5));
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_BevelBorder1()));
      } /* End if */
    return _Panel4;
  } /* End of Method: get_Panel4 */

  /*
     * Method: Panel4_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel4_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel4_CreateInstance */

  /*
     * Method: get_BevelBorder1
     * Params: None
     * Return: javax.swing.border.BevelBorder
     */
  protected javax.swing.border.BevelBorder get_BevelBorder1()
  {
    if (_BevelBorder1 == null)
      {
        _BevelBorder1 = new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED);
      } /* End if */
    return _BevelBorder1;
  } /* End of Method: get_BevelBorder1 */

  /*
     * Method: get_Panel1
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel1()
  {
    if (_Panel1 == null)
      {
        _Panel1 = Panel1_CreateInstance();
        javax.swing.JPanel self = _Panel1;
        self.setName("Panel1");
        /* set Layout */
        self.setLayout(new java.awt.BorderLayout(5,5));
        /* Adds Child */
        self.add(get_EditorPane_Pane(),java.awt.BorderLayout.CENTER);
      } /* End if */
    return _Panel1;
  } /* End of Method: get_Panel1 */

  /*
     * Method: Panel1_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel1_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel1_CreateInstance */

  /*
     * Method: get_EditorPane_Pane
     * Params: None
     * Return: javax.swing.JScrollPane
     */
  protected javax.swing.JScrollPane get_EditorPane_Pane()
  {
    if (_EditorPane_Pane == null)
      {
        _EditorPane_Pane = EditorPane_Pane_CreateInstance();
        javax.swing.JScrollPane self = _EditorPane_Pane;
        self.setName("EditorPane");
        self.setViewportView(get_EditorPane());
        self.setBounds(0,1,520,536);
        self.setPreferredSize(new java.awt.Dimension(520,536));
        self.setMinimumSize(new java.awt.Dimension(520,536));
        self.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        self.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
      } /* End if */
    return _EditorPane_Pane;
  } /* End of Method: get_EditorPane_Pane */

  /*
     * Method: EditorPane_Pane_CreateInstance
     * Params: None
     * Return: javax.swing.JScrollPane
     */
  protected javax.swing.JScrollPane EditorPane_Pane_CreateInstance()
  {
    return new javax.swing.JScrollPane();
  } /* End of Method: EditorPane_Pane_CreateInstance */

  /*
     * Method: get_EditorPane
     * Params: None
     * Return: javax.swing.JEditorPane
     */
  protected javax.swing.JEditorPane get_EditorPane()
  {
    if (_EditorPane == null)
      {
        _EditorPane = EditorPane_CreateInstance();
        javax.swing.JEditorPane self = _EditorPane;
        self.setName("EditorPane");
        self.setBackground(new java.awt.Color(204,204,204));
        self.setEditable(false);
        try {
          self.setPage(getClass().getResource("./help.htm"));
        } catch (Exception e) {};
      } /* End if */
    return _EditorPane;
  } /* End of Method: get_EditorPane */

  /*
     * Method: EditorPane_CreateInstance
     * Params: None
     * Return: javax.swing.JEditorPane
     */
  protected javax.swing.JEditorPane EditorPane_CreateInstance()
  {
    return new javax.swing.JEditorPane();
  } /* End of Method: EditorPane_CreateInstance */

  /*
     * Method: get_Panel2
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel2()
  {
    if (_Panel2 == null)
      {
        _Panel2 = Panel2_CreateInstance();
        javax.swing.JPanel self = _Panel2;
        self.setName("Panel2");
        /* set Layout */
        self.setLayout(new java.awt.BorderLayout(5,5));
        /* Adds Children */
        self.add(get_EditorPane1_Pane(),java.awt.BorderLayout.CENTER);
        self.add(get_Panel6(),java.awt.BorderLayout.NORTH);
      } /* End if */
    return _Panel2;
  } /* End of Method: get_Panel2 */

  /*
     * Method: Panel2_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel2_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel2_CreateInstance */

  /*
     * Method: get_EditorPane1_Pane
     * Params: None
     * Return: javax.swing.JScrollPane
     */
  protected javax.swing.JScrollPane get_EditorPane1_Pane()
  {
    if (_EditorPane1_Pane == null)
      {
        _EditorPane1_Pane = EditorPane1_Pane_CreateInstance();
        javax.swing.JScrollPane self = _EditorPane1_Pane;
        self.setName("EditorPane1");
        self.setViewportView(get_EditorPane1());
        self.setBounds(0,0,533,367);
        self.setPreferredSize(new java.awt.Dimension(533,367));
        self.setMinimumSize(new java.awt.Dimension(533,367));
        self.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        self.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
      } /* End if */
    return _EditorPane1_Pane;
  } /* End of Method: get_EditorPane1_Pane */

  /*
     * Method: EditorPane1_Pane_CreateInstance
     * Params: None
     * Return: javax.swing.JScrollPane
     */
  protected javax.swing.JScrollPane EditorPane1_Pane_CreateInstance()
  {
    return new javax.swing.JScrollPane();
  } /* End of Method: EditorPane1_Pane_CreateInstance */

  /*
     * Method: get_EditorPane1
     * Params: None
     * Return: javax.swing.JEditorPane
     */
  protected javax.swing.JEditorPane get_EditorPane1()
  {
    if (_EditorPane1 == null)
      {
        _EditorPane1 = EditorPane1_CreateInstance();
        javax.swing.JEditorPane self = _EditorPane1;
        self.setName("EditorPane1");
        self.setBackground(new java.awt.Color(204,204,204));
        self.setEditable(false);
        try {
          self.setPage(getClass().getResource("./about.htm"));
        } catch (Exception e) {};
      } /* End if */
    return _EditorPane1;
  } /* End of Method: get_EditorPane1 */

  /*
     * Method: EditorPane1_CreateInstance
     * Params: None
     * Return: javax.swing.JEditorPane
     */
  protected javax.swing.JEditorPane EditorPane1_CreateInstance()
  {
    return new javax.swing.JEditorPane();
  } /* End of Method: EditorPane1_CreateInstance */

  /*
     * Method: get_Panel6
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel get_Panel6()
  {
    if (_Panel6 == null)
      {
        _Panel6 = Panel6_CreateInstance();
        javax.swing.JPanel self = _Panel6;
        self.setName("Panel6");
        self.setBounds(0,0,520,25);
        self.setPreferredSize(new java.awt.Dimension(520,25));
        self.setMinimumSize(new java.awt.Dimension(520,25));
        /* set Layout */
        self.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT,1,1));
        /* Adds Children */
        self.add(get_Button3());
        javax.swing.ButtonGroup buttonGroup = new javax.swing.ButtonGroup();
        buttonGroup.add(get_Button3());
        self.add(get_Button4());
        buttonGroup.add(get_Button4());
      } /* End if */
    return _Panel6;
  } /* End of Method: get_Panel6 */

  /*
     * Method: Panel6_CreateInstance
     * Params: None
     * Return: javax.swing.JPanel
     */
  protected javax.swing.JPanel Panel6_CreateInstance()
  {
    return new javax.swing.JPanel();
  } /* End of Method: Panel6_CreateInstance */

  /*
     * Method: get_Button3
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton get_Button3()
  {
    if (_Button3 == null)
      {
        _Button3 = Button3_CreateInstance();
        javax.swing.JButton self = _Button3;
        self.setName("Button3");
        self.setBounds(210,1,24,24);
        self.setPreferredSize(new java.awt.Dimension(24,24));
        self.setMinimumSize(new java.awt.Dimension(24,24));
        self.setText("");
        self.setIcon(new ImageIcon(getClass().getResource("./prev.gif")));
        /* Adds Listener(s) */
        self.addActionListener(new Button3_ActionAdapter());
      } /* End if */
    return _Button3;
  } /* End of Method: get_Button3 */

  /*
     * Method: Button3_CreateInstance
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton Button3_CreateInstance()
  {
    return new javax.swing.JButton();
  } /* End of Method: Button3_CreateInstance */

  /*
     * Method: Button3_actionPerformed
     * Note  : Invoked when an action occurs.
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
  protected abstract void Button3_actionPerformed(java.awt.event.ActionEvent evt);
  /* This abstract method is overloaded by the "Main.java" source code. */

    /*
     * Class:   Button3_ActionAdapter
     * Interface: ActionListener
     * Adapter: java.awt.event.Action
     */
  protected class Button3_ActionAdapter implements java.awt.event.ActionListener
  {
    /*
     * Interface: ActionListener
     * Method: actionPerformed
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button3_actionPerformed(evt);
    } /* End of Method: actionPerformed */
  } /* End of Class: Button3_ActionAdapter */

  /*
     * Method: get_Button4
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton get_Button4()
  {
    if (_Button4 == null)
      {
        _Button4 = Button4_CreateInstance();
        javax.swing.JButton self = _Button4;
        self.setName("Button4");
        self.setBounds(260,1,24,24);
        self.setPreferredSize(new java.awt.Dimension(24,24));
        self.setMinimumSize(new java.awt.Dimension(24,24));
        self.setText("");
        self.setIcon(new ImageIcon(getClass().getResource("./next.gif")));
        /* Adds Listener(s) */
        self.addActionListener(new Button4_ActionAdapter());
      } /* End if */
    return _Button4;
  } /* End of Method: get_Button4 */

  /*
     * Method: Button4_CreateInstance
     * Params: None
     * Return: javax.swing.JButton
     */
  protected javax.swing.JButton Button4_CreateInstance()
  {
    return new javax.swing.JButton();
  } /* End of Method: Button4_CreateInstance */

  /*
     * Method: Button4_actionPerformed
     * Note  : Invoked when an action occurs.
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
  protected abstract void Button4_actionPerformed(java.awt.event.ActionEvent evt);
  /* This abstract method is overloaded by the "Main.java" source code. */

    /*
     * Class:   Button4_ActionAdapter
     * Interface: ActionListener
     * Adapter: java.awt.event.Action
     */
  protected class Button4_ActionAdapter implements java.awt.event.ActionListener
  {
    /*
     * Interface: ActionListener
     * Method: actionPerformed
     * Params: java.awt.event.ActionEvent
     * Return: void
     */
    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button4_actionPerformed(evt);
    } /* End of Method: actionPerformed */
  } /* End of Class: Button4_ActionAdapter */

  /*
     * Method: get_EtchedBorder
     * Params: None
     * Return: javax.swing.border.EtchedBorder
     */
  protected javax.swing.border.EtchedBorder get_EtchedBorder()
  {
    if (_EtchedBorder == null)
      {
        _EtchedBorder = new javax.swing.border.EtchedBorder(javax.swing.border.EtchedBorder.RAISED);
      } /* End if */
    return _EtchedBorder;
  } /* End of Method: get_EtchedBorder */

  /*
     * Method: generalHandleException
     * Params: java.lang.Throwable exception
     * Return: void
     */
  protected void generalHandleException(java.lang.Throwable exc)
  { /* This primitive method is overloaded by the "Main.java" source code. */
    // Uncaught Exception
  } /* End of Method: generalHandleException */
} /* End of Class: Grapher_Abstract   */
