/*
* Surfacer.java
*/
package meshviz.graph.advanced.Surfacer;

import java.awt.BorderLayout;
import java.net.URL;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.engines.SoCalculator;
import com.openinventor.inventor.fields.SoMFFloat;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoQuadMesh;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoAutoCubeAxis;
import com.openinventor.meshviz.graph.PoBase;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.misc.callbacks.PoRebuildCB;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;


public class Main extends Surfacer_Abstract {
  SoSeparator sceneRoot;
  IViewerExaminer viewer;
  String formula = "sin(2*M_PI*a)*cos(2*M_PI*b)";
  Vector<URL> listURL;
  int curURL = -1;

  public Main() {
    super();

    listURL = new Vector<URL>();
    listURL.add(getClass().getResource("./about.htm"));
    curURL++;

    get_EditorPane1().addHyperlinkListener(new Hyperactive());
  }

  @Override
  protected void generalHandleException(java.lang.Throwable exc) {
    exc.printStackTrace(System.err);
  }

  public static void main(java.lang.String[] arg) {
    Main example = new Main();
    example.initScene();
    JFrame frame = example.get_Frame();
    frame.setVisible(true);
  }

  @Override
  public void start() {
    initScene();
    setLayout(new BorderLayout());
    add(get_TabbedPane());
    setVisible(true);
  }

  @Override
  public void stop()
  {
    viewer.dispose();
  }

  public void initScene() {
    viewer = ViewerComponentsFactory.createViewerExaminer();
    sceneRoot = new SoSeparator();
    updateView(0,1,50,0,1,50);
    get_Panel4().add("Center",viewer.getComponent());
    viewer.setSceneGraph(sceneRoot);
    viewer.viewAll();
  }

  public void updateView(float xminVal, float xmaxVal, int xnumVal,float yminVal, float ymaxVal, int ynumVal) {
    SoCalculator calc = new SoCalculator();
    calc.expression.set1Value(0,"oa="+formula);
    SoMFFloat outputVal1 = (SoMFFloat)SoDB.createGlobalField("outputVal1",SoMFFloat.class);
    outputVal1.connectFrom(calc.oa);
    SbVec3f [] points = new SbVec3f[xnumVal*ynumVal];
    float xmin,xmax,ymin,ymax,zmin,zmax;
    xmin = Float.MAX_VALUE;
    xmax = Float.MIN_VALUE;
    ymin = Float.MAX_VALUE;
    ymax = Float.MIN_VALUE;
    zmin = Float.MAX_VALUE;
    zmax = Float.MIN_VALUE;
    float xstep = (xmaxVal-xminVal)/(xnumVal-1);
    float ystep = (ymaxVal-yminVal)/(ynumVal-1);
    float b = yminVal;
    for(int i=0; i<ynumVal; i++, b += ystep) {
      float a = xminVal;
      for(int j=0; j<xnumVal; j++, a += xstep) {
        calc.a.setValue(a);
        calc.b.setValue(b);
        float x = a;
        float y = b;
        float z = outputVal1.getValueAt(0);
        xmin = Math.min(xmin,x);
        xmax = Math.max(xmax,x);
        ymin = Math.min(ymin,y);
        ymax = Math.max(ymax,y);
        zmin = Math.min(zmin,z);
        zmax = Math.max(zmax,z);
        points[i*xnumVal+j] = new SbVec3f(x,y,z);
      }
    }
    sceneRoot.removeAllChildren();

    PoDomain domain = new PoDomain();
    domain.min.setValue(new SbVec3f(xmin,ymin,zmin));
    domain.max.setValue(new SbVec3f(xmax,ymax,zmax));
    domain.transformType.setValue(PoDomain.TransformTypes.TRANSFORM_01);
    sceneRoot.addChild(domain);

    sceneRoot.addChild(buildAxis(xmin,ymin,zmin,xmax,ymax,zmax));

    sceneRoot.addChild(domain.getTransform());

    SoShapeHints hints = new SoShapeHints();
    hints.faceType.setValue(SoShapeHints.FaceTypes.CONVEX);
    hints.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);
    hints.shapeType.setValue(SoShapeHints.ShapeTypes.UNKNOWN_SHAPE_TYPE);
    sceneRoot.addChild(hints);

    SoBaseColor color = new SoBaseColor();
    color.rgb.setValue(.7f,.5f,.2f);
    sceneRoot.addChild(color);

    SoVertexProperty property = new SoVertexProperty();
    property.vertex.setValues(0,points);
    SoQuadMesh mesh = new SoQuadMesh();
    mesh.vertexProperty.setValue(property);
    mesh.verticesPerRow.setValue(xnumVal);
    mesh.verticesPerColumn.setValue(ynumVal);
    sceneRoot.addChild(mesh);
  }


  protected SoSeparator buildAxis(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
    SoSeparator axisSep= new SoSeparator();
    PoAutoCubeAxis axis = new PoAutoCubeAxis(new SbVec3f(xmin,ymin,zmin),new SbVec3f(xmax,ymax,zmax),
                                             PoAutoCubeAxis.AxisTypes.LINEAR,PoAutoCubeAxis.AxisTypes.LINEAR,PoAutoCubeAxis.AxisTypes.LINEAR,
                                             "X", "Y", "Z") ;
    axis.set("backgroundFaceApp.material", "diffuseColor .5 .1 .1") ;
    axis.set("backgroundFaceApp.material", "transparency .75") ;
    axis.isBackgroundFacesVisible.setValue(true) ;
    axis.isGridLinesXVisible.setValue(true);
    axis.isGridLinesYVisible.setValue(true);
    axis.isGridLinesZVisible.setValue(true);

    String [] axisPart = {
      "xAxis03","xAxis12","xAxis65","xAxis74",
      "yAxis01","yAxis76","yAxis45","yAxis32",
      "zAxis07","zAxis34","zAxis25","zAxis16"
    };
    for (int i = 0; i < 12; i++) {
      PoLinearAxis lAxis = (PoLinearAxis)axis.getPart(axisPart[i]);
      lAxis.addPostRebuildCallback(new axisCB(),null);
    }

    axisSep.addChild(axis);

    return axisSep;
  }

  class axisCB extends PoRebuildCB {
    @Override
    public void invoke(PoBase base) {
      PoLinearAxis axis = (PoLinearAxis)base;
      axis.set("mainGradTextApp.font","name TGS_Simplex_TGS");
      axis.set("titleApp.font","name TGS_Simplex_TGS");
      axis.set("multFactorApp.font","name TGS_Simplex_TGS");
    }
  }

  @Override
  protected void Button_actionPerformed(java.awt.event.ActionEvent evt)
  {
    formula = get_TextField().getText();
    float xvmin = Float.valueOf(get_TextField2x().getText()).floatValue();
    float xvmax = Float.valueOf(get_TextField3x().getText()).floatValue();
    int xnumPoints = Integer.valueOf(get_TextField4x().getText()).intValue();
    float yvmin = Float.valueOf(get_TextField2y().getText()).floatValue();
    float yvmax = Float.valueOf(get_TextField3y().getText()).floatValue();
    int ynumPoints = Integer.valueOf(get_TextField4y().getText()).intValue();
    updateView(xvmin,xvmax,xnumPoints,yvmin,yvmax,ynumPoints);
  }

  @Override
  protected void Frame_windowClosed(java.awt.event.WindowEvent evt)
  {
    stop();
    System.exit(0);
  }

  class Hyperactive implements HyperlinkListener {
    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
      if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        try {
          if (curURL < listURL.size()-1) {
            listURL.add(listURL.elementAt(curURL));
            curURL++;
          }
          listURL.add(e.getURL());
          curURL++;
          get_EditorPane1().setPage(e.getURL());
        } catch (Throwable t) {t.printStackTrace();}
      }
    }
  }

  @Override
  protected void Button3_actionPerformed(java.awt.event.ActionEvent evt)
  {
    if (curURL > 0) {
      curURL--;
      try {
        get_EditorPane1().setPage((listURL.elementAt(curURL)));
      } catch (Exception e) {}
    }

  }

  @Override
  protected void Button4_actionPerformed(java.awt.event.ActionEvent evt)
  {
    if (curURL < listURL.size()-1) {
      curURL++;
      try {
        get_EditorPane1().setPage((listURL.elementAt(curURL)));
      } catch (Exception e) {}
    }
  }
}

abstract class Surfacer_Abstract extends Example
{
  private javax.swing.JFrame _Frame;
  private javax.swing.JTabbedPane _TabbedPane;
  private javax.swing.JPanel _Panel;
  private javax.swing.JPanel _Panel3;
  private javax.swing.border.BevelBorder _BevelBorder;
  private javax.swing.JLabel _Label;
  private javax.swing.JTextField _TextField;
  private javax.swing.JLabel _Label2x;
  private javax.swing.JLabel _Label3x;
  private javax.swing.JLabel _Label4x;
  private javax.swing.JTextField _TextField2x;
  private javax.swing.JTextField _TextField3x;
  private javax.swing.JTextField _TextField4x;
  private javax.swing.JLabel _Label2y;
  private javax.swing.JLabel _Label3y;
  private javax.swing.JLabel _Label4y;
  private javax.swing.JTextField _TextField2y;
  private javax.swing.JTextField _TextField3y;
  private javax.swing.JTextField _TextField4y;
  private javax.swing.JButton _Button;
  private javax.swing.JPanel _Panel4;
  private javax.swing.border.BevelBorder _BevelBorder1;
  private javax.swing.JPanel _Panel1;
  private javax.swing.JEditorPane _EditorPane;
  private javax.swing.JScrollPane _EditorPane_Pane;
  private javax.swing.JPanel _Panel2;
  private javax.swing.JEditorPane _EditorPane1;
  private javax.swing.JScrollPane _EditorPane1_Pane;
  private javax.swing.JPanel _Panel6;
  private javax.swing.JButton _Button3;
  private javax.swing.JButton _Button4;
  private javax.swing.border.EtchedBorder _EtchedBorder;

  protected Surfacer_Abstract()
  {
    super();
  }

  protected javax.swing.JFrame get_Frame()
  {
    if (_Frame == null)
      {
        _Frame = Frame_CreateInstance();
        javax.swing.JFrame self = _Frame;
        self.setName("Frame");
        self.setBounds(72,46,650,600);
        self.setTitle("Open Inventor Java - Surfacer demo");
        self.setResizable(true);
        self.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        self.getContentPane().add(get_TabbedPane(),java.awt.BorderLayout.CENTER);
        self.addWindowListener(new Frame_WindowAdapter());
      }
    return _Frame;
  }

  protected javax.swing.JFrame Frame_CreateInstance()
  {
    return new javax.swing.JFrame();
  }

  protected abstract void Frame_windowClosed(java.awt.event.WindowEvent evt);

  protected class Frame_WindowAdapter implements java.awt.event.WindowListener
  {
    @Override
    public void windowOpened(java.awt.event.WindowEvent evt){}
    @Override
    public void windowClosing(java.awt.event.WindowEvent evt){}
    @Override
    public void windowIconified(java.awt.event.WindowEvent evt){}
    @Override
    public void windowDeiconified(java.awt.event.WindowEvent evt){}
    @Override
    public void windowActivated(java.awt.event.WindowEvent evt){}
    @Override
    public void windowDeactivated(java.awt.event.WindowEvent evt){}
    @Override
    public void windowClosed(java.awt.event.WindowEvent evt)
    {
      Frame_windowClosed(evt);
    }
  }

  protected javax.swing.JTabbedPane get_TabbedPane()
  {
    if (_TabbedPane == null)
      {
        _TabbedPane = TabbedPane_CreateInstance();
        javax.swing.JTabbedPane self = _TabbedPane;
        self.setName("TabbedPane");
        self.setOpaque(false);
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_EtchedBorder()));
        self.insertTab("Graph",null,get_Panel(),null,0);
        self.insertTab("Help",null,get_Panel1(),null,1);
        self.insertTab("About",null,get_Panel2(),null,2);
      }
    return _TabbedPane;
  }

  protected javax.swing.JTabbedPane TabbedPane_CreateInstance()
  {
    return new javax.swing.JTabbedPane();
  }

  protected javax.swing.JPanel get_Panel()
  {
    if (_Panel == null)
      {
        _Panel = Panel_CreateInstance();
        javax.swing.JPanel self = _Panel;
        self.setName("Panel");
        self.setLayout(new java.awt.BorderLayout(5,5));
        self.add(get_Panel3(),java.awt.BorderLayout.SOUTH);
        self.add(get_Panel4(),java.awt.BorderLayout.CENTER);
      }
    return _Panel;
  }

  protected javax.swing.JPanel Panel_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.JPanel get_Panel3()
  {
    if (_Panel3 == null)
      {
        _Panel3 = Panel3_CreateInstance();
        javax.swing.JPanel self = _Panel3;
        self.setName("Panel3");
        self.setBounds(0,0,565,100);
        self.setPreferredSize(new java.awt.Dimension(565,100));
        self.setMinimumSize(new java.awt.Dimension(565,100));
        java.awt.GridBagLayout gridBagLayout = new java.awt.GridBagLayout();
        self.setLayout(gridBagLayout);
        java.awt.GridBagConstraints constraints = new java.awt.GridBagConstraints();
        constraints.insets = new java.awt.Insets(1,1,1,1);
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_BevelBorder()));
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = java.awt.GridBagConstraints.WEST;
        constraints.fill = java.awt.GridBagConstraints.NONE;
        gridBagLayout.setConstraints(get_Label(), constraints);
        self.add(get_Label());

        constraints.gridx = 1;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_TextField(), constraints);
        self.add(get_TextField());

        constraints.gridx = 2;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_Label2x(), constraints);
        self.add(get_Label2x());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_Label3x(), constraints);
        self.add(get_Label3x());
        constraints.gridy = 2;
        gridBagLayout.setConstraints(get_Label4x(), constraints);
        self.add(get_Label4x());
        constraints.gridx = 3;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_TextField2x(), constraints);
        self.add(get_TextField2x());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_TextField3x(), constraints);
        self.add(get_TextField3x());
        constraints.gridy = 2;
        gridBagLayout.setConstraints(get_TextField4x(), constraints);
        self.add(get_TextField4x());

        constraints.gridx = 4;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_Label2y(), constraints);
        self.add(get_Label2y());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_Label3y(), constraints);
        self.add(get_Label3y());
        constraints.gridy = 2;
        gridBagLayout.setConstraints(get_Label4y(), constraints);
        self.add(get_Label4y());
        constraints.gridx = 5;
        constraints.gridy = 0;
        gridBagLayout.setConstraints(get_TextField2y(), constraints);
        self.add(get_TextField2y());
        constraints.gridy = 1;
        gridBagLayout.setConstraints(get_TextField3y(), constraints);
        self.add(get_TextField3y());
        constraints.gridy = 2;
        gridBagLayout.setConstraints(get_TextField4y(), constraints);
        self.add(get_TextField4y());

        constraints.gridx = 6;
        constraints.gridy = 2;
        gridBagLayout.setConstraints(get_Button(), constraints);
        self.add(get_Button());
        javax.swing.ButtonGroup buttonGroup = new javax.swing.ButtonGroup();
        buttonGroup.add(get_Button());
      }
    return _Panel3;
  }

  protected javax.swing.JPanel Panel3_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.border.BevelBorder get_BevelBorder()
  {
    if (_BevelBorder == null)
      {
        _BevelBorder = new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED);
      }
    return _BevelBorder;
  }

  protected javax.swing.JLabel get_Label()
  {
    if (_Label == null)
      {
        _Label = Label_CreateInstance();
        javax.swing.JLabel self = _Label;
        self.setName("Label");
        self.setBounds(255,12,90,22);
        self.setPreferredSize(new java.awt.Dimension(90,22));
        self.setMinimumSize(new java.awt.Dimension(90,22));
        self.setText("z=f(a,b)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label;
  }

  protected javax.swing.JLabel Label_CreateInstance()
  {
    return new javax.swing.JLabel();
  }


  protected javax.swing.JTextField get_TextField()
  {
    if (_TextField == null)
      {
        _TextField = TextField_CreateInstance();
        javax.swing.JTextField self = _TextField;
        self.setName("TextField");
        self.setBounds(401,32,200,22);
        self.setPreferredSize(new java.awt.Dimension(200,22));
        self.setMinimumSize(new java.awt.Dimension(200,22));
        self.setEditable(true);
        self.setText("sin(2*M_PI*a)*cos(2*M_PI*b)");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField;
  }

  protected javax.swing.JTextField TextField_CreateInstance()
  {
    return new javax.swing.JTextField();
  }


  protected javax.swing.JLabel get_Label2x()
  {
    if (_Label2x == null)
      {
        _Label2x = Label2x_CreateInstance();
        javax.swing.JLabel self = _Label2x;
        self.setName("Label2x");
        self.setBounds(252,22,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("a min");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label2x;
  }

  protected javax.swing.JLabel Label2x_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JLabel get_Label2y()
  {
    if (_Label2y == null)
      {
        _Label2y = Label2y_CreateInstance();
        javax.swing.JLabel self = _Label2y;
        self.setName("Label2y");
        self.setBounds(252,22,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("b min");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label2y;
  }

  protected javax.swing.JLabel Label2y_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JLabel get_Label3x()
  {
    if (_Label3x == null)
      {
        _Label3x = Label3x_CreateInstance();
        javax.swing.JLabel self = _Label3x;
        self.setName("Label3x");
        self.setBounds(202,26,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("a max");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label3x;
  }

  protected javax.swing.JLabel Label3x_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JLabel get_Label3y()
  {
    if (_Label3y == null)
      {
        _Label3y = Label3y_CreateInstance();
        javax.swing.JLabel self = _Label3y;
        self.setName("Label3y");
        self.setBounds(202,26,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("b max");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label3y;
  }

  protected javax.swing.JLabel Label3y_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JTextField get_TextField2x()
  {
    if (_TextField2x == null)
      {
        _TextField2x = TextField2x_CreateInstance();
        javax.swing.JTextField self = _TextField2x;
        self.setName("TextField2x");
        self.setBounds(198,8,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("0");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField2x;
  }

  protected javax.swing.JTextField TextField2x_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JTextField get_TextField2y()
  {
    if (_TextField2y == null)
      {
        _TextField2y = TextField2y_CreateInstance();
        javax.swing.JTextField self = _TextField2y;
        self.setName("TextField2y");
        self.setBounds(198,8,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("0");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField2y;
  }

  protected javax.swing.JTextField TextField2y_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JTextField get_TextField3x()
  {
    if (_TextField3x == null)
      {
        _TextField3x = TextField3x_CreateInstance();
        javax.swing.JTextField self = _TextField3x;
        self.setName("TextField3x");
        self.setBounds(165,5,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("1");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField3x;
  }

  protected javax.swing.JTextField TextField3x_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JTextField get_TextField3y()
  {
    if (_TextField3y == null)
      {
        _TextField3y = TextField3y_CreateInstance();
        javax.swing.JTextField self = _TextField3y;
        self.setName("TextField3y");
        self.setBounds(165,5,80,22);
        self.setPreferredSize(new java.awt.Dimension(80,22));
        self.setMinimumSize(new java.awt.Dimension(80,22));
        self.setEditable(true);
        self.setText("1");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField3y;
  }

  protected javax.swing.JTextField TextField3y_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JLabel get_Label4x()
  {
    if (_Label4x == null)
      {
        _Label4x = Label4x_CreateInstance();
        javax.swing.JLabel self = _Label4x;
        self.setName("Label4x");
        self.setBounds(161,22,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("x#points");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label4x;
  }

  protected javax.swing.JLabel Label4x_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JLabel get_Label4y()
  {
    if (_Label4y == null)
      {
        _Label4y = Label4y_CreateInstance();
        javax.swing.JLabel self = _Label4y;
        self.setName("Label4y");
        self.setBounds(161,22,55,22);
        self.setPreferredSize(new java.awt.Dimension(55,22));
        self.setMinimumSize(new java.awt.Dimension(55,22));
        self.setText("y#points");
        self.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      }
    return _Label4y;
  }

  protected javax.swing.JLabel Label4y_CreateInstance()
  {
    return new javax.swing.JLabel();
  }

  protected javax.swing.JTextField get_TextField4x()
  {
    if (_TextField4x == null)
      {
        _TextField4x = TextField4x_CreateInstance();
        javax.swing.JTextField self = _TextField4x;
        self.setName("TextField4x");
        self.setBounds(254,30,50,22);
        self.setPreferredSize(new java.awt.Dimension(50,22));
        self.setMinimumSize(new java.awt.Dimension(50,22));
        self.setEditable(true);
        self.setText("50");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField4x;
  }

  protected javax.swing.JTextField TextField4x_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JTextField get_TextField4y()
  {
    if (_TextField4y == null)
      {
        _TextField4y = TextField4y_CreateInstance();
        javax.swing.JTextField self = _TextField4y;
        self.setName("TextField4y");
        self.setBounds(254,30,50,22);
        self.setPreferredSize(new java.awt.Dimension(50,22));
        self.setMinimumSize(new java.awt.Dimension(50,22));
        self.setEditable(true);
        self.setText("50");
        self.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      }
    return _TextField4y;
  }

  protected javax.swing.JTextField TextField4y_CreateInstance()
  {
    return new javax.swing.JTextField();
  }

  protected javax.swing.JButton get_Button()
  {
    if (_Button == null)
      {
        _Button = Button_CreateInstance();
        javax.swing.JButton self = _Button;
        self.setName("Button");
        self.setBounds(231,37,50,22);
        self.setPreferredSize(new java.awt.Dimension(50,22));
        self.setMinimumSize(new java.awt.Dimension(50,22));
        self.setText("Go");
        self.addActionListener(new Button_ActionAdapter());
      }
    return _Button;
  }

  protected javax.swing.JButton Button_CreateInstance()
  {
    return new javax.swing.JButton();
  }


  protected abstract void Button_actionPerformed(java.awt.event.ActionEvent evt);
  protected class Button_ActionAdapter implements java.awt.event.ActionListener
  {

    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button_actionPerformed(evt);
    }
  }

  protected javax.swing.JPanel get_Panel4()
  {
    if (_Panel4 == null)
      {
        _Panel4 = Panel4_CreateInstance();
        javax.swing.JPanel self = _Panel4;
        self.setName("Panel4");
        self.setBounds(0,55,533,312);
        self.setPreferredSize(new java.awt.Dimension(533,312));
        self.setMinimumSize(new java.awt.Dimension(533,312));
        self.setLayout(new java.awt.BorderLayout(5,5));
        self.setBorder(new javax.swing.border.CompoundBorder(self.getBorder(),get_BevelBorder1()));
      }
    return _Panel4;
  }

  protected javax.swing.JPanel Panel4_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.border.BevelBorder get_BevelBorder1()
  {
    if (_BevelBorder1 == null)
      {
        _BevelBorder1 = new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED);
      }
    return _BevelBorder1;
  }

  protected javax.swing.JPanel get_Panel1()
  {
    if (_Panel1 == null)
      {
        _Panel1 = Panel1_CreateInstance();
        javax.swing.JPanel self = _Panel1;
        self.setName("Panel1");
        self.setLayout(new java.awt.BorderLayout(5,5));
        self.add(get_EditorPane_Pane(),java.awt.BorderLayout.CENTER);
      }
    return _Panel1;
  }

  protected javax.swing.JPanel Panel1_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.JScrollPane get_EditorPane_Pane()
  {
    if (_EditorPane_Pane == null)
      {
        _EditorPane_Pane = EditorPane_Pane_CreateInstance();
        javax.swing.JScrollPane self = _EditorPane_Pane;
        self.setName("EditorPane");
        self.setViewportView(get_EditorPane());
        self.setBounds(0,1,520,536);
        self.setPreferredSize(new java.awt.Dimension(520,536));
        self.setMinimumSize(new java.awt.Dimension(520,536));
        self.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        self.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
      }
    return _EditorPane_Pane;
  }

  protected javax.swing.JScrollPane EditorPane_Pane_CreateInstance()
  {
    return new javax.swing.JScrollPane();
  }

  protected javax.swing.JEditorPane get_EditorPane()
  {
    if (_EditorPane == null)
      {
        _EditorPane = EditorPane_CreateInstance();
        javax.swing.JEditorPane self = _EditorPane;
        self.setName("EditorPane");
        self.setBackground(new java.awt.Color(204,204,204));
        self.setEditable(false);
        try {
          self.setPage(getClass().getResource("./help.htm"));
        } catch (Exception e) {};
      }
    return _EditorPane;
  }

  protected javax.swing.JEditorPane EditorPane_CreateInstance()
  {
    return new javax.swing.JEditorPane();
  }

  protected javax.swing.JPanel get_Panel2()
  {
    if (_Panel2 == null)
      {
        _Panel2 = Panel2_CreateInstance();
        javax.swing.JPanel self = _Panel2;
        self.setName("Panel2");
        self.setLayout(new java.awt.BorderLayout(5,5));
        self.add(get_EditorPane1_Pane(),java.awt.BorderLayout.CENTER);
        self.add(get_Panel6(),java.awt.BorderLayout.NORTH);
      }
    return _Panel2;
  }

  protected javax.swing.JPanel Panel2_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.JScrollPane get_EditorPane1_Pane()
  {
    if (_EditorPane1_Pane == null)
      {
        _EditorPane1_Pane = EditorPane1_Pane_CreateInstance();
        javax.swing.JScrollPane self = _EditorPane1_Pane;
        self.setName("EditorPane1");
        self.setViewportView(get_EditorPane1());
        self.setBounds(0,0,533,367);
        self.setPreferredSize(new java.awt.Dimension(533,367));
        self.setMinimumSize(new java.awt.Dimension(533,367));
        self.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        self.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
      }
    return _EditorPane1_Pane;
  }

  protected javax.swing.JScrollPane EditorPane1_Pane_CreateInstance()
  {
    return new javax.swing.JScrollPane();
  }

  protected javax.swing.JEditorPane get_EditorPane1()
  {
    if (_EditorPane1 == null)
      {
        _EditorPane1 = EditorPane1_CreateInstance();
        javax.swing.JEditorPane self = _EditorPane1;
        self.setName("EditorPane1");
        self.setBackground(new java.awt.Color(204,204,204));
        self.setEditable(false);
        try {
          self.setPage(getClass().getResource("./about.htm"));
        } catch (Exception e) {};
      }
    return _EditorPane1;
  }

  protected javax.swing.JEditorPane EditorPane1_CreateInstance()
  {
    return new javax.swing.JEditorPane();
  }

  protected javax.swing.JPanel get_Panel6()
  {
    if (_Panel6 == null)
      {
        _Panel6 = Panel6_CreateInstance();
        javax.swing.JPanel self = _Panel6;
        self.setName("Panel6");
        self.setBounds(0,0,520,25);
        self.setPreferredSize(new java.awt.Dimension(520,25));
        self.setMinimumSize(new java.awt.Dimension(520,25));
        self.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT,1,1));
        self.add(get_Button3());
        javax.swing.ButtonGroup buttonGroup = new javax.swing.ButtonGroup();
        buttonGroup.add(get_Button3());
        self.add(get_Button4());
        buttonGroup.add(get_Button4());
      }
    return _Panel6;
  }

  protected javax.swing.JPanel Panel6_CreateInstance()
  {
    return new javax.swing.JPanel();
  }

  protected javax.swing.JButton get_Button3()
  {
    if (_Button3 == null)
      {
        _Button3 = Button3_CreateInstance();
        javax.swing.JButton self = _Button3;
        self.setName("Button3");
        self.setBounds(210,1,24,24);
        self.setPreferredSize(new java.awt.Dimension(24,24));
        self.setMinimumSize(new java.awt.Dimension(24,24));
        self.setText("");
        self.setIcon(new ImageIcon(getClass().getResource("./prev.gif")));
        self.addActionListener(new Button3_ActionAdapter());
      }
    return _Button3;
  }

  protected javax.swing.JButton Button3_CreateInstance()
  {
    return new javax.swing.JButton();
  }

  protected abstract void Button3_actionPerformed(java.awt.event.ActionEvent evt);
  protected class Button3_ActionAdapter implements java.awt.event.ActionListener
  {
    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button3_actionPerformed(evt);
    }
  }

  protected javax.swing.JButton get_Button4()
  {
    if (_Button4 == null)
      {
        _Button4 = Button4_CreateInstance();
        javax.swing.JButton self = _Button4;
        self.setName("Button4");
        self.setBounds(260,1,24,24);
        self.setPreferredSize(new java.awt.Dimension(24,24));
        self.setMinimumSize(new java.awt.Dimension(24,24));
        self.setText("");
        self.setIcon(new ImageIcon(getClass().getResource("./next.gif")));
        self.addActionListener(new Button4_ActionAdapter());
      }
    return _Button4;
  }

  protected javax.swing.JButton Button4_CreateInstance()
  {
    return new javax.swing.JButton();
  }

  protected abstract void Button4_actionPerformed(java.awt.event.ActionEvent evt);
  protected class Button4_ActionAdapter implements java.awt.event.ActionListener
  {
    @Override
    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
      Button4_actionPerformed(evt);
    }
  }

  protected javax.swing.border.EtchedBorder get_EtchedBorder()
  {
    if (_EtchedBorder == null)
      {
        _EtchedBorder = new javax.swing.border.EtchedBorder(javax.swing.border.EtchedBorder.RAISED);
      }
    return _EtchedBorder;
  }

  protected void generalHandleException(java.lang.Throwable exc) {}
}
