package meshviz.graph.advanced.pieChart3D;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.misc.callbacks.SoSelectionPathCB;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoPieChart;
import com.openinventor.meshviz.graph.PoPieChart3D;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;
import com.openinventor.meshviz.nodes.PoNumericDisplayFormat;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private static final float TRANSLATE_VALUE = 0.75F ;
  private static final float PIDIV4 = 0.785F ;

  private IViewerExaminer myViewer;
  private PoPieChart3D pieChart3D;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Pie Chart 3D");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    String[] sliceTexts = {"Austria", "Canada", "C.I.S", "Czechoslovakia", "Finland",
			   "France", "Germany", "Italy", "Japan", "Luxemburg",
			   "Netherland", "New Zealand", "North Korea", "Norway",
			   "South Korea", "Spain", "Sweden", "Switzerland", "United States"} ;
    float[] sliceValues = {6, 2, 9, 0, 3, 3, 10, 4, 1, 0, 1, 0, 0, 9, 2, 1, 1, 1, 5} ;
    SbColor[] sliceColors = { new SbColor(0.4F, 1, 1), new SbColor(0.2F, 0.1F, 1),
			      new SbColor(1, 0.1F, 1), new SbColor(1, 0.6F, 0.5F),
			      new SbColor(0.7F, 0, 0.4F), new SbColor(0.8F, 0.2F, 0.2F),
			      new SbColor(0.1F, 1, 0.5F), new SbColor(0.1F, 0.8F, 0.1F),
			      new SbColor(0, 0.6F, 0)} ;

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10, 10,10);

    PoNumericDisplayFormat format = new PoNumericDisplayFormat();
    format.formatType.setValue(PoNumericDisplayFormat.FormatTypes.INTEGER_FORMAT);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    SoRotationXYZ rotation = new SoRotationXYZ() ;
    rotation.axis.setValue(SoRotationXYZ.AxisType.X) ;
    rotation.angle.setValue(-PIDIV4) ;

    pieChart3D = new PoPieChart3D(new SbVec3f(5, 5, 3), 4, 2.5F, sliceTexts,
				  sliceValues, sliceColors) ;

    pieChart3D.sliceGroupMinValue.setValue(3) ;
    pieChart3D.sliceGroupFlagMin.setValue(PoPieChart.PercentStatus.ABSOLUTE) ;
    pieChart3D.sliceToTranslateNumber.set1Value(0, (short) 4) ;
    pieChart3D.sliceToTranslateValue.set1Value(0, TRANSLATE_VALUE) ;
    pieChart3D.extAnnotTextFontSize.setValue(0.04F) ;
    pieChart3D.set("sliceBorderApp.drawStyle", "lineWidth 2") ;
    pieChart3D.set("extAnnotBoxBorderApp.material", "diffuseColor 0 0 0") ;

    SoSelection root = new SoSelection();
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(format);
      root.addChild(textAttr);
      root.addSelectionCallback(new SelectionPathCB());
      root.addChild(rotation);
      root.addChild(pieChart3D);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  // / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / /
  // inner class
  // / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / /
  class SelectionPathCB extends SoSelectionPathCB {
    @Override
    public void invoke(SoPath path) {
      if ( myViewer.getRenderArea().getInteractionMode() == InteractionMode.NAVIGATION )
        return;

    	try {

	int slicePicked = pieChart3D.getPickedSliceNumber(path) ;
	if (pieChart3D.getSliceToTranslate(slicePicked) <= 0)
	  pieChart3D.setSliceToTranslate(slicePicked, TRANSLATE_VALUE) ;
	else
	  pieChart3D.setSliceToTranslate(slicePicked, 0) ;
      } catch (IllegalArgumentException e) {}
    }
  }
}
