package meshviz.graph.advanced.prettyCurve;

import java.awt.* ;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.* ;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.* ;
import com.openinventor.meshviz.nodes.* ;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  static protected Color UIBackgroundColor = new Color(148F/255F,174F/255F,211F/255F);
  static protected Color UIForegroundColor = Color.blue;

  static protected SbColor GraphicBackgroundColor1 = new SbColor(166F/255F,189F/255F,234F/255F);
  static protected SbColor GraphicBackgroundColor2 = new SbColor(30F/255F,61F/255F,122F/255F);

  private IViewerExaminer myViewer;
  PoMesh1DHints          Mesh1DHints ;
  PoCurveLine            CurveLine ;
  PoLinearBar            LinearBar ;
  PoConicBar             ConicBar ;
  PoCylindricalBar       CylindricalBar ;
  PoProfileBar           ProfileBar ;
  PoGeneralizedBar       GeneralizedBar ;
  PoScatter              Scatter ;
  PoGeneralizedScatter   GenScatter ;
  PoLabel                Label ;
  PoLabelHints           LabelHints ;
  SoSeparator            Root ;
  SoSwitch               BarSwitch ;
  SoSwitch               CurveSwitch ;
  SoSwitch               FilterSwitch ;
  SoSwitch               ScatterSwitch ;
  SoSwitch               GenScatterSwitch ;
  SoSwitch               LabelSwitch ;
  PoIrregularMesh1D      Mesh1D ;
  SoCoordinate3          Coord3PointSet ;
  PoDomain               MyDomain ;
  PoPeriodFilter         PeriodFilter ;
  PoCoordinateListFilter CoordListFilter ;
  PoGroup2Axis           G2Axis ;
  SoScale                ScaleBar ;
  int                    CurrentDataSet=0 ;

  int                    CurrentBarType=2;

  static float XVert[][] = {
    {0.5f, 1.5f, 1.8f, 2.4f, 3.2f, 4.5f, 6.3f, 6.9f, 8.0f, 8.5f, 9.0f, 9.5f, 9.8f, 10f},
    {0.5f, 1.5f, 1.8f, 2.4f, 3.2f, 4.5f, 6.3f, 6.9f, 8.0f, 8.5f, 9.0f, 9.5f, 9.8f, 10f},
    {0.05f, 0.15f, 0.18f, 0.24f, 0.32f, 0.45f, 0.63f, 0.69f, 0.80f, 0.85f, 0.90f, 0.95f, 0.98f, 1.0f}
  } ;


  static float YVert[][] = {
    {0.5f, 3.8f, 1.2f, 1.9f, 6.3f, 7.2f, 9.3f, 7.2f, 6.0f, 6.3f, 7.5f, 4.1f, 3.5f, 1.5f},
    {0.05f, 0.38f, 0.12f, 0.19f, 0.63f, 0.72f, 0.93f, 0.72f, 0.60f, 0.63f, 0.75f, 0.41f, 0.35f, 0.15f},
    {0.5f, 3.8f, 1.2f, 1.9f, 6.3f, 7.2f, 9.3f, 7.2f, 6.0f, 6.3f, 7.5f, 4.1f, 3.5f, 1.5f}
  } ;

  static String NamesVert[] = {"A", "B", "C", "D", "E", "", "G",
                               "H", "I", "J", "K", "L", "M", "N"} ;


  static float SizeVert[] = {1f, 2f, 5f, 1f, 2f, 5f, 1f, 2f, 5f, 1f, 2f, 5f, 1f, 2f} ;

  static float XHor[][] = {
    {1.f, 2.f, 3.f,  5.f,  5.5f, 3.5f, 2.5f, 4.5f},
    {1.f, 2.f, 3.f,  5.f,  5.5f, 3.5f, 2.5f, 4.5f},
    {0.1f, 0.2f, 0.3f,  0.55f,  0.55f, 0.35f, 0.25f, 0.45f }
  } ;

  static float YHor[][] = {
    {0.f, 1.f, 2.5f, 3.4f, 4f,   4.5f, 6.f,  7.2f},
    {0.f, 0.1f, 0.25f, 0.34f, 0.4f, 0.45f, 0.6f,  0.72f},
    {0.f, 1.f, 2.5f, 3.4f, 4f,   4.5f, 6.f,  7.2f}
  } ;

  static float SizeHor[] = {1f, 3f, 5f, 1f, 3f, 5f, 1f, 6f} ;

  static String NamesHor[] = {"a", "b", "c", "d", "e", "f", "g", "h"} ;

  static int indexList[] = {0, 3, 4, 7, 10} ;

  static float coordsFilter[] = {0.5f, 2f, 4f, 6f, 9f} ;


  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SbColor colors[] = {
      new SbColor(0.0f,0.f,1.0f), new SbColor(0.0f,1.0f,0.0f),
      new SbColor(1.0f,1.f,0.f),  new SbColor(1.0f,.5f,0.0f),
      new SbColor(1.0f,0.0f,0.0f)
        } ;
    float val[] = { 0f, 2.5f, 5f, 7.5f, 10.f};


    SbColor colorList[] = {new SbColor(1,0,0), new SbColor(0, 1, 0), new SbColor(0, 0, 1)} ;

    PoBase.setTextType(PoBase.TextTypes.SO_TEXT3) ;

    MyDomain = new PoDomain() ;
    MyDomain.min.setValue(0.f, 0.f, 0.f) ;
    MyDomain.max.setValue(10.f, 10.f, 10.f) ;

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr() ;
    myTextAttr.fontName.setValue("Courier New") ;
    myTextAttr.profileEnabled.setValue(true);

    Mesh1D = new PoIrregularMesh1D() ;
    Mesh1D.setGeometry( XVert[0].length, XVert[0]) ;
    Mesh1D.addValuesSet(0, YVert[0], "Vert") ;
    Mesh1D.addValuesSet(1, SizeVert) ;

    Mesh1DHints = new PoMesh1DHints() ;

    PoNonLinearDataMapping2 dataMapping = new PoNonLinearDataMapping2() ;
    dataMapping.color.setValues(0, colors) ;
    dataMapping.value.setValues(0, val) ;

    CurveLine = new PoCurveLine() ;

    SoMaterial mat = new SoMaterial() ;
    mat.diffuseColor.setValues(0, colorList) ;
    CurveLine.material.setValue(mat) ;
    CurveLine.colorValuesIndex.setValue(0) ;
    CurveLine.thicknessFactor.setValue(0.5f) ;

    G2Axis = new
      PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10, 10),
                   PoGroup2Axis.AxisTypes.LINEAR,
                   PoGroup2Axis.AxisTypes.LINEAR,
                   "X-Axis", "Y-Axis") ;
    PoLinearAxis xAxis = (PoLinearAxis)G2Axis.getPart("xAxis") ;
    xAxis.gradPath.setValue(PoAxis.TextPaths.PATH_DOWN);

    Coord3PointSet = new SoCoordinate3() ;
    for(int i=0; i < XVert[CurrentDataSet].length; i++)
      Coord3PointSet.point.set1Value(i,
                                     XVert[CurrentDataSet][i],
                                     YVert[CurrentDataSet][i],
                                     0) ;

    SoDrawStyle style = new SoDrawStyle() ;
    style.pointSize.setValue(5) ;

    LinearBar  = new PoLinearBar() ;
    LinearBar.material.setValue(mat) ;

    ConicBar = new PoConicBar() ;
    ConicBar.material.setValue(mat) ;
    ConicBar.bottomRadius.setValue(0.5f) ;

    CylindricalBar = new PoCylindricalBar() ;
    CylindricalBar.material.setValue(mat) ;
    CylindricalBar.radius.setValue(0.1f) ;

    ProfileBar = new PoProfileBar() ;
    ProfileBar.material.setValue(mat) ;

    SoSeparator coneSep = new SoSeparator() ;
    coneSep.addChild(new SoCone());

    SoSeparator cylinderSep = new SoSeparator() ;
    cylinderSep.addChild(new SoCylinder()) ;

    SoSeparator cubeSep = new SoSeparator() ;
    cubeSep.addChild(new SoCube()) ;

    /*
    SoInput input ;
    input.openFile("../../datafile/queen.iv") ;
    SoSeparator queenSep = SoDB::readAll(&input) ;
    input.closeFile() ;
    */
    SoSeparator queenSep = new SoSeparator();

    SoScale scale = new SoScale() ;
    scale.scaleFactor.setValue(70,70,70) ;
    queenSep.insertChild(scale, 0) ;
    GeneralizedBar = new PoGeneralizedBar();
    GeneralizedBar.scaleFactor.setValue(0.35f, 0.35f, 0.35f) ;
    GeneralizedBar.material.setValue(mat) ;
    GeneralizedBar.bars.set1Value(0, coneSep) ;
    GeneralizedBar.bars.set1Value(1, cylinderSep) ;
    GeneralizedBar.bars.set1Value(2, queenSep) ;

    FilterSwitch = new SoSwitch() ;

    PoPeriodIndexFilter periodIndexFilter = new PoPeriodIndexFilter() ;
    periodIndexFilter.period.setValue(2) ;

    PoIndexListFilter indexListFilter = new PoIndexListFilter() ;
    indexListFilter.index.setValues(0, indexList) ;

    PeriodFilter = new PoPeriodFilter() ;
    PeriodFilter.period.setValue(1) ;

    CoordListFilter = new PoCoordinateListFilter() ;
    CoordListFilter.coord.setValues(0, coordsFilter) ;

    FilterSwitch = new SoSwitch() ;
    FilterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE) ;
    FilterSwitch.addChild(periodIndexFilter) ;
    FilterSwitch.addChild(indexListFilter) ;
    FilterSwitch.addChild(PeriodFilter) ;
    FilterSwitch.addChild(CoordListFilter) ;

    BarSwitch = new SoSwitch() ;
    BarSwitch.whichChild.setValue(2); //SoSwitch.SO_SWITCH_NONE);
    BarSwitch.addChild(LinearBar) ;
    BarSwitch.addChild(ConicBar) ;
    BarSwitch.addChild(CylindricalBar) ;
    BarSwitch.addChild(ProfileBar) ;
    BarSwitch.addChild(GeneralizedBar) ;

    SoSeparator barSep = new SoSeparator() ;
    ScaleBar = new SoScale() ;
    barSep.addChild(ScaleBar) ;
    barSep.addChild(BarSwitch) ;

    CurveSwitch = new SoSwitch() ;
    CurveSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL) ;
    CurveSwitch.addChild(CurveLine) ;

    SoMaterial material = new SoMaterial() ;
    material.diffuseColor.setValue(0.6f,  0.f, 0.f) ;
    material.specularColor.setValue(0.8f, 0.f, 0.f) ;
    material.shininess.setValue(0.4f) ;

    PoSquareProfile squareProfile = new PoSquareProfile() ;
    squareProfile.width.setValue(0.5f) ;
    squareProfile.height.setValue(0.5f) ;

    ScatterSwitch = new SoSwitch() ;
    ScatterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE) ;

    Scatter = new PoScatter() ;
    Scatter.material.setValue(mat) ;
    Scatter.markerIndex.set1Value(0, SoMarkerSet.MarkerTypes.SATELLITE_FILLED_9_9.getValue()) ;
    Scatter.markerIndex.set1Value(1, SoMarkerSet.MarkerTypes.CIRCLE_FILLED_9_9.getValue()) ;
    ScatterSwitch.addChild(Scatter) ;

    GenScatterSwitch = new SoSwitch() ;
    GenScatterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE) ;

    SoSeparator sphereSep = new SoSeparator() ;
    sphereSep.addChild(new SoSphere()) ;

    GenScatter = new PoGeneralizedScatter() ;
    GenScatter.markers.setValue(sphereSep) ;
    GenScatter.sizeValuesIndex.setValue(1) ;
    GenScatter.scaleFactor.setValue(0.5f, 0.5f, 0.5f) ;
    GenScatter.material.setValue(mat) ;
    GenScatterSwitch.addChild(GenScatter) ;

    SoMaterial myMaterial = new SoMaterial();
    myMaterial.diffuseColor.setValue(1,1,0);
    myMaterial.specularColor.setValue(1,1,1);
    myMaterial.shininess.setValue(.1f);
    G2Axis.setPart("xAxis.mainGradTextApp.material", myMaterial) ;
    G2Axis.setPart("yAxis.mainGradTextApp.material", myMaterial) ;
    G2Axis.setPart("xAxis.titleApp.material", myMaterial) ;
    G2Axis.setPart("yAxis.titleApp.material", myMaterial) ;

    LabelSwitch = new SoSwitch() ;
    LabelSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL) ;

    Label = new PoLabel() ;
    Label.setPart("appearance.material", myMaterial) ;
    //  Label.offset.setValue(1.,-1.5,0.5) ;
    Label.material.setValue(mat) ;
    SoAnnotation anno = new SoAnnotation();
        anno.addChild(Label);
    //    LabelSwitch.addChild(Label) ;
    LabelSwitch.addChild(anno) ;

    LabelHints = new PoLabelHints() ;

    // attach color binding fields
    LinearBar.colorBinding.connectFrom(CurveLine.colorBinding) ;
    ConicBar.colorBinding.connectFrom(CurveLine.colorBinding) ;
    CylindricalBar.colorBinding.connectFrom(CurveLine.colorBinding) ;
    ProfileBar.colorBinding.connectFrom(CurveLine.colorBinding) ;
    GeneralizedBar.colorBinding.connectFrom(CurveLine.colorBinding) ;
    Scatter.colorBinding.connectFrom(CurveLine.colorBinding) ;
    GenScatter.colorBinding.connectFrom(CurveLine.colorBinding) ;
    Label.colorBinding.connectFrom(CurveLine.colorBinding) ;

    Root = new SoSeparator() ;
    { // assemble scene graph
      Root.addChild(style);
      // Root.addChild(Coord3PointSet) ;
      // Root.addChild(new SoPointSet) ;
      Root.addChild(Mesh1D);
      Root.addChild(FilterSwitch);
      Root.addChild(dataMapping);
      Root.addChild(MyDomain);
      Root.addChild(myTextAttr);
      Root.addChild(Mesh1DHints);
      Root.addChild(CurveSwitch);
      Root.addChild(G2Axis);
      Root.addChild(material);
      Root.addChild(squareProfile);
      Root.addChild(ScatterSwitch);
      Root.addChild(GenScatterSwitch);
      Root.addChild(barSep);
      Root.addChild(LabelHints);
      Root.addChild(LabelSwitch);
    }

    myViewer.setSceneGraph(Root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(makeUserInterface(), BorderLayout.WEST);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  Panel makeUserInterface() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints constraint = new GridBagConstraints();
    constraint.anchor = GridBagConstraints.WEST;
    constraint.insets.bottom = 10;
    constraint.insets.top = 10;
    constraint.insets.left = 10;
    constraint.insets.right = 10;

    Panel leftPanel = new Panel(gridbag) {
      @Override
      public void paint(Graphics g) {
	Dimension d = getSize() ;
	g.setColor(UIForegroundColor) ;
	int margin = 1;
	g.drawRect(margin,margin, d.width-2*margin, d.height-2*margin);
      }
    };
    leftPanel.setBackground(UIBackgroundColor);

    /*------------ show bar ------------*/
    Label labelShowBar = new Label("Show/Hide bar");
    labelShowBar.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelShowBar,constraint);
    leftPanel.add(labelShowBar);

    Checkbox checkShowBar = new Checkbox("",true);
    checkShowBar.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          if (BarSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_NONE)
            BarSwitch.whichChild.setValue(CurrentBarType);
          else
            BarSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        }});

    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(checkShowBar,constraint);
    leftPanel.add(checkShowBar);

    /*------------ type bar ------------*/
    Label labelTypeBar = new Label("Type bar");
    labelTypeBar.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelTypeBar,constraint);
    leftPanel.add(labelTypeBar);

    Choice choiceTypeBar = new Choice();
    choiceTypeBar.addItem("LINEAR");
    choiceTypeBar.addItem("CONIC");
    choiceTypeBar.addItem("CYLINDRICAL");
    choiceTypeBar.addItem("PROFILE");
    choiceTypeBar.addItem("GENERALIZED");
    choiceTypeBar.select(CurrentBarType) ;
    choiceTypeBar.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          Choice c = (Choice)e.getSource();
          CurrentBarType = c.getSelectedIndex();
          if (BarSwitch.whichChild.getValue() != SoSwitch.SO_SWITCH_NONE)
            BarSwitch.whichChild.setValue(CurrentBarType);
        }});
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceTypeBar,constraint);
    leftPanel.add(choiceTypeBar);

    /*------------ show scatter ------------*/
    Label labelShowScatter = new Label("Show/Hide scatter");
    labelShowScatter.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelShowScatter,constraint);
    leftPanel.add(labelShowScatter);

    Checkbox checkShowScatter = new Checkbox("",false);
    checkShowScatter.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          if (ScatterSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_NONE)
            ScatterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          else
            ScatterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        }});

    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(checkShowScatter,constraint);
    leftPanel.add(checkShowScatter);

    /*------------ show label ------------*/
    Label labelShowLabel = new Label("Show/Hide label");
    labelShowLabel.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelShowLabel,constraint);
    leftPanel.add(labelShowLabel);

    Checkbox checkShowLabel = new Checkbox("",true);
    checkShowLabel.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          if (LabelSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_NONE)
            LabelSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          else
            LabelSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        }});

    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(checkShowLabel,constraint);
    leftPanel.add(checkShowLabel);

    /*------------ label position ------------*/
    Label labelLabelPosition = new Label("label position");
    labelLabelPosition.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelLabelPosition,constraint);
    leftPanel.add(labelLabelPosition);

    Choice choiceLabelPosition = new Choice();
    choiceLabelPosition.addItem("VALUE_POS");
    choiceLabelPosition.addItem("MIDDLE_POS");
    choiceLabelPosition.addItem("THRESHOLD_POS");
    choiceLabelPosition.select(0);
    choiceLabelPosition.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          Choice c = (Choice)e.getSource();
          Label.position.setValue(c.getSelectedIndex());
        }});
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceLabelPosition,constraint);
    leftPanel.add(choiceLabelPosition);

    /*------------ mesh hints ------------*/
    Label labelMeshHints = new Label("Mesh hints");
    labelMeshHints.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelMeshHints,constraint);
    leftPanel.add(labelMeshHints);

    Choice choiceMeshHints = new Choice();
    choiceMeshHints.addItem("POLYGONAL");
    choiceMeshHints.addItem("SMOOTH");
    choiceMeshHints.addItem("STAIRS_X");
    choiceMeshHints.addItem("STAIRS_Y");
    choiceMeshHints.addItem("HISTO_X");
    choiceMeshHints.addItem("HISTO_Y");
    choiceMeshHints.addItem("STAIRS_2X");
    choiceMeshHints.addItem("STAIRS_2Y");
    choiceMeshHints.select(0);
    choiceMeshHints.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          Choice c = (Choice)e.getSource();
          Mesh1DHints.geomInterpretation.setValue(c.getSelectedIndex());
        }});
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceMeshHints,constraint);
    leftPanel.add(choiceMeshHints);

    /*------------ Color binding ------------*/
    Label labelColorBinding = new Label("Color binding");
    labelColorBinding.setForeground(UIForegroundColor);
    constraint.gridwidth = 1;
    gridbag.setConstraints(labelColorBinding,constraint);
    leftPanel.add(labelColorBinding);

    Choice choiceColorBinding = new Choice();
    choiceColorBinding.addItem("INHERITED");
    choiceColorBinding.addItem("PER_VERTEX");
    choiceColorBinding.addItem("PER_PART");
    choiceColorBinding.select(0);
    choiceColorBinding.addItemListener(new ItemListener() {
        @Override
        public void itemStateChanged(ItemEvent e) {
          Choice c = (Choice)e.getSource();
          CurveLine.colorBinding.setValue(c.getSelectedIndex());
        }});
    constraint.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(choiceColorBinding,constraint);
    leftPanel.add(choiceColorBinding);


    return leftPanel;
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("CurveLine");
  }


}/*---------------------------------------------------------------------------*/

