package meshviz.graph.advanced.singleHistogram;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTransformSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoCartesianAxis.Types;
import com.openinventor.meshviz.graph.PoHistogram;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoSingleHistogram;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoLinearDataMapping;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Single Histogram");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    String[] names = {"JAN","FEB","MAR","APR","MAY","JUNE","JULY","AUG"};
    float[] value = {5, 10, 8, 12, 6, 7, 4, 3};

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10,10,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;
    textAttr.lineLength.setValue((short)5);
    textAttr.endLineChar.setValue((short)'%');

    PoLinearDataMapping dataMapping = new PoLinearDataMapping() ;
    dataMapping.color1.setValue(new SbColor(1,1,1));
    dataMapping.color2.setValue(new SbColor(0,1,0));
    dataMapping.value1.setValue(3);
    dataMapping.value2.setValue(12);

    PoSingleHistogram histog = new PoSingleHistogram(new SbVec2f(-3, 1), 13,
						     PoHistogram.Types.X,
						     value, names) ;

    histog.set("barApp.material", "diffuseColor 0. 1. 0.") ;
    histog.set("valueTextApp.material", "diffuseColor 1 1 1") ;
    histog.set("nameTextApp.material", "diffuseColor 1 1 1") ;
    histog.coloring.setValue(PoHistogram.Colorings.DATA_MAPPING) ;
    histog.valueFontSize.setValue(0.06F) ;
    histog.nameFontSize.setValue(0.06F) ;

    PoSingleHistogram histog2 = new PoSingleHistogram(new SbVec2f(-3, 1), 13,
						      PoHistogram.Types.X,
						      value, null) ;

    histog2.set("barApp.material", "diffuseColor 0. 0.5 0.") ;
    histog2.nameVisibility.setValue(PoHistogram.Visibilities.VISIBILITY_OFF) ;
    histog2.valueVisibility.setValue(PoHistogram.Visibilities.VISIBILITY_OFF) ;

    PoLinearAxis yAxis = new PoLinearAxis(new SbVec3f(-3,1,0), 13, Types.YX) ;
    yAxis.gradFontSize.setValue(0.06F) ;
    yAxis.titleString.setValue("Price%(M Dollars)") ;
    yAxis.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    yAxis.titleFontSize.setValue(0.06F) ;
    yAxis.set("appearance.material", "diffuseColor 1 1 1") ;
    yAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    yAxis.set("bodyApp.drawStyle", "lineWidth 2.0") ;

    SoTranslation translate = new SoTranslation() ;
    translate.translation.setValue(0.2F, 0.3F, 0) ;

    SoTransformSeparator transSep = new SoTransformSeparator() ;
    transSep.addChild(translate) ;
    transSep.addChild(histog2) ;

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(dataMapping);
      root.addChild(yAxis);
      root.addChild(transSep);
      root.addChild(histog);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
