// ArrowExample
package meshviz.graph.mentor.arrowExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoArrow;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Arrow Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create the arrow and set appearance
    PoArrow myArrow = new PoArrow();
    SbVec2f[] points = new SbVec2f[3];
    points[0] = new SbVec2f(0.0f, 0.0f);
    points[1] = new SbVec2f(10.0f, 10.0f);
    points[2] = new SbVec2f(20.0f, 10.0f);
    myArrow.point.setValues(0, points);
    myArrow.endPatternType.setValue(PoArrow.PatternTypes.DIRECT_TRIANGLE);
    myArrow.set("endApp.material", "diffuseColor 1 0 0");
    myArrow.set("appearance.material", "diffuseColor 0 0 0");
    myArrow.patternWidth.setValue(.1f);
    myArrow.patternHeight.setValue(.075f);

    // Set the domain to define end pattern size
    PoDomain myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0.0f, 0.0f, 0.0f));
    myDom.max.setValue(new SbVec3f(20.0f, 20.0f, 0.0f));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of our scene graph
    SoAnnotation root = new SoAnnotation();
    root.addChild(background);
    root.addChild(myDom);
    root.addChild(myArrow);

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
