// AxisExample1 : simple axis
package meshviz.graph.mentor.axisExample1;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCartesianAxis;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Axis Example 1");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create the curve
    PoCurve myCurve = new PoCurve();
    SbVec2f[] points = new SbVec2f[NUM_POINTS];
    double ang;
    int i;
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points[i]= new SbVec2f((float)ang, (float)(6 * Math.sin(ang)));
    myCurve.point.setValues(0, points);
    myCurve.set("curvePointApp.material", "diffuseColor [1 0 0]");

    // Create simple automatic X and Y linear axis
    // Do not forget to set the domain if you want
    // default parameters to be correct...

    PoLinearAxis myXAxis = new PoLinearAxis();
    myXAxis.start.setValue(new SbVec3f(0, 0, 0));
    myXAxis.end.setValue((float)(4*Math.PI));
    myXAxis.type.setValue(PoCartesianAxis.Types.XY);
    myXAxis.set("appearance.material", "diffuseColor 0 0 0") ;

    PoLinearAxis myYAxis = new PoLinearAxis();
    myYAxis.start.setValue(new SbVec3f(0, -6, 0));
    myYAxis.end.setValue(6);
    myYAxis.type.setValue(PoCartesianAxis.Types.YX);
    myYAxis.set("appearance.material", "diffuseColor 0 0 0") ;

    PoDomain myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0,-6,0));
    myDom.max.setValue(new SbVec3f((float)(4*Math.PI), 6, 0));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myDom);
      root.addChild(myXAxis);
      root.addChild(myYAxis);
      root.addChild(myCurve);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
