// AxisExample5 : multiple curves
package meshviz.graph.mentor.axisExample5;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCurve;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private static final int NUM_POINTS = 50;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Axis Example 5");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    // Create the curves
    double ang;
    int i;
    SbVec2f[] points1 = new SbVec2f[NUM_POINTS];
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points1[i] = new SbVec2f((float)ang, (float)(6 * Math.sin(ang)));
    PoCurve myCurve1 = new PoCurve();
    myCurve1.point.setValues(0, points1);
    myCurve1.set("curvePointApp.material", "diffuseColor [1 0 0]");

    SbVec2f[] points2 = new SbVec2f[NUM_POINTS];
    for(i=0, ang=0; i<NUM_POINTS; i++, ang += 4*Math.PI/NUM_POINTS)
      points2[i] = new SbVec2f((float)ang, (float)(Math.PI * Math.cos(ang)));
    PoCurve myCurve2 = new PoCurve();
    myCurve2.point.setValues(0, points2);
    myCurve2.set("curvePointApp.material", "diffuseColor [0 1 0]");


    // Create a group of 2 axis and edit some fields of them
    PoGroup2Axis my2Axis = new PoGroup2Axis();
    my2Axis.start.setValue(new SbVec2f(0, -6));
    my2Axis.end.setValue(new SbVec2f((float)(4*Math.PI), 6));
    my2Axis.xTitle.setValue("Multiple curves");
    my2Axis.set("appearance.material", "diffuseColor 0 0 0") ;


    PoDomain myDom = new PoDomain();
    myDom.min.setValue(new SbVec3f(0,-6,0));
    myDom.max.setValue(new SbVec3f((float)(4*Math.PI), 6, 0));

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myDom);
      root.addChild(myCurve1);
      root.addChild(myCurve2);
      root.addChild(my2Axis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
