// ValueLegendExample
package meshviz.graph.mentor.valueLegendExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoLinearValueLegend;
import com.openinventor.meshviz.nodes.PoIsovaluesList;
import com.openinventor.meshviz.nodes.PoLinearDataMapping;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Value Legend Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoLinearDataMapping myDataMapping = new PoLinearDataMapping();
    myDataMapping.value1.setValue(0);
    myDataMapping.value2.setValue(10);
    myDataMapping.color1.setValue(0,0,1);
    myDataMapping.color2.setValue(1,0,0);

    // Define list of values
    PoIsovaluesList myList = new PoIsovaluesList();
    myList.setRegularIsoList(0.0F, 9.0F, 10);

    // Create the legend node
    PoLinearValueLegend legend =
      new PoLinearValueLegend(new SbVec2f(0, 0), new SbVec2f(0.3F, 1.0F)) ;
    legend.set("backgroundApp.material", "diffuseColor .4 .4 .4") ;

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of our scene graph
    SoAnnotation root = new SoAnnotation();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myList);
      root.addChild(myDataMapping);
      root.addChild(legend);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
