package meshviz.graph.sample.angularAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAngularAxis;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoDomain domain = new PoDomain();
    domain.min.setValue(-1, -1, 0);
    domain.max.setValue( 1, 1, 0) ;

    PoAngularAxis angularAxis = new PoAngularAxis(0.5F, 0, 2.5F, 1, 0) ;
    angularAxis.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    angularAxis.titlePosition.setValue(PoAxis.TitlePositions.TITLE_END) ;
    angularAxis.titleString.setValue("X-Axis") ;
    angularAxis.gradPath.setValue(PoAxis.TextPaths.PATH_UP) ;
    angularAxis.gridVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    angularAxis.gridLengthGradSide.setValue(0) ;
    angularAxis.gridLengthGradOtherSide.setValue(0.4F) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(textAttr);
      root.addChild(domain);
      root.addChild(angularAxis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Angular Axis");
  }
}
