package meshviz.graph.sample.biErrorPointField;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoBiErrorPointField;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{
  static final int NP = 12 ;
  static SbVec2f[] point = {new SbVec2f(0.5F, 0.5F), new SbVec2f(1.5F, 3.8F), new SbVec2f(1.8F, 1.2F),
			    new SbVec2f(2.4F, 1.9F), new SbVec2f(3.2F, 8.3F), new SbVec2f(4.5F, 4),
			    new SbVec2f(5.9F, 3.2F), new SbVec2f(6.3F, 9.5F), new SbVec2f(8, 3),
			    new SbVec2f(8.5F, 6.3F), new SbVec2f(9.0F, 7.5F), new SbVec2f(9.5F, 9.1F)} ;
  static float[] lowXR = {0.4F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1, 0.4F, 0.2F, 0.8F} ;
  static float[] lowYR = {0.4F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1, 0.4F, 0.2F, 0.8F} ;
  static float[] highXR = {1, 0.6F, 0.5F, 0.2F, 0.4F, 0.6F, 0.8F, 0.5F, 1, 0.3F, 0.5F, 0.5F} ;
  static float[] highYR = {1.5F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1, 0.4F, 0.2F, 0.8F} ;

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoBiErrorPointField berrPtFld = new PoBiErrorPointField(point, lowXR, lowYR, highXR, highYR) ;

    berrPtFld.set("shapeApp.material", "diffuseColor [0 0 1]") ;
    berrPtFld.set("skeletonApp.material", "diffuseColor [1 0 0]") ;

    SoAnnotation root = new SoAnnotation() ;
    root.addChild(berrPtFld) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Bi-Error Point Field");
  }
}
