package meshviz.graph.sample.circle;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCircleCenterRadius;
import com.openinventor.meshviz.graph.PoCircleThreePoints;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoCircleCenterRadius circle = new PoCircleCenterRadius(new SbVec2f(5, 5), 1) ;
    PoCircleThreePoints circle2 = new PoCircleThreePoints() ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(circle);
      root.addChild(circle2);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Circle");
  }
}
