package meshviz.graph.sample.circle3;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCircle3CenterRadius;
import com.openinventor.meshviz.graph.PoCircle3ThreePoints;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoCircle3CenterRadius circle = new PoCircle3CenterRadius(new SbVec3f(5, 5, 0), 1,
							     new SbVec3f(1, 0, 1)) ;
    PoCircle3ThreePoints circle2 = new PoCircle3ThreePoints() ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(circle);
      root.addChild(circle2);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Circle3");
  }
}
