package meshviz.graph.sample.circleArc;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoCircleArcCtrPtAngle;
import com.openinventor.meshviz.graph.PoCircleArcCtrRadTwoAngle;
import com.openinventor.meshviz.graph.PoCircleArcCtrTwoPts;
import com.openinventor.meshviz.graph.PoCircleArcThreePts;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoCircleArcCtrPtAngle circleArc = new PoCircleArcCtrPtAngle(new SbVec2f(0, 0),
								new SbVec2f(1, 0), 1.5F) ;
    PoCircleArcCtrTwoPts circleArc2 = new PoCircleArcCtrTwoPts(new SbVec2f(2, 2),
							       new SbVec2f(2.5F, 1.7F),
							       new SbVec2f(2.1F, 2.5F)) ;
    PoCircleArcThreePts circleArc3 = new PoCircleArcThreePts(new SbVec2f(-2, -2),
							     new SbVec2f(-2.5F, -2.5F),
							     new SbVec2f(-3, -1)) ;
    PoCircleArcCtrRadTwoAngle circleArc4 = new PoCircleArcCtrRadTwoAngle(new SbVec2f(-2, -2),
        1, 0.8F, 2.5F) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(circleArc);
      root.addChild(circleArc2);
      root.addChild(circleArc3);
      root.addChild(circleArc4);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("CircleArc");
  }
}
