package meshviz.graph.sample.circleArc3;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCircleArc3CtrPtAngle;
import com.openinventor.meshviz.graph.PoCircleArc3CtrTwoPts;
import com.openinventor.meshviz.graph.PoCircleArc3ThreePts;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoCircleArc3CtrPtAngle circleArc =
        new PoCircleArc3CtrPtAngle(new SbVec3f(0,0,0),
                                   new SbVec3f(1,0,0), 1.5F,
                                   new SbVec3f(0, 0.5F, 0.5F)) ;

    PoCircleArc3CtrTwoPts circleArc2 =
        new PoCircleArc3CtrTwoPts(new SbVec3f(2,2,0),
                                  new SbVec3f(2.5F, 1.7F, 0),
                                  new SbVec3f(2.1F, 2.5F, 0)) ;

    PoCircleArc3ThreePts circleArc3 =
        new PoCircleArc3ThreePts(new SbVec3f(-2,-2,0),
                                 new SbVec3f(-2.5F, -2.5F, 0),
                                 new SbVec3f(-3, -2, 0)) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(circleArc);
      root.addChild(circleArc2);
      root.addChild(circleArc3);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Circle Arc 3");
  }
}
