package meshviz.graph.sample.coordinateSystemAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoCoordinateSystemAxis;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoCoordinateSystemAxis coordSystAxis = new PoCoordinateSystemAxis() ;

    coordSystAxis.titleTranslationFactor.setValue(0.1F) ;
    coordSystAxis.set("xArrow.appearance.material", "diffuseColor 1 0 0") ;
    coordSystAxis.set("yArrow.appearance.material", "diffuseColor 0 1 0") ;
//    coordSystAxis.set("zArrow.appearance.material", "diffuseColor 0 0 1") ;
    coordSystAxis.set("appearance.font", "name Arial size 10") ;

    SoSeparator root = new SoSeparator() ;
    root.addChild(coordSystAxis) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Coordinate System Axis");
  }
}
